/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AbstractOptimizer;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public class HiLoOptimizer
extends AbstractOptimizer {
    private static final Logger log = Logger.getLogger(HiLoOptimizer.class);
    private final Lock lock = new ReentrantLock();
    private GenerationState noTenantState;
    private Map<String, GenerationState> tenantSpecificState;

    public HiLoOptimizer(Class<?> returnClass, int incrementSize) {
        super(returnClass, incrementSize);
        if (incrementSize < 1) {
            throw new HibernateException("increment size cannot be less than 1");
        }
        if (log.isTraceEnabled()) {
            log.tracev("Creating hilo optimizer with [incrementSize={0}; returnClass={1}]", (Object)incrementSize, (Object)returnClass.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable generate(AccessCallback callback) {
        this.lock.lock();
        try {
            GenerationState generationState = this.locateGenerationState(callback.getTenantIdentifier());
            if (generationState.lastSourceValue == null) {
                generationState.lastSourceValue = callback.getNextValue();
                while (generationState.lastSourceValue.lt(1L)) {
                    generationState.lastSourceValue = callback.getNextValue();
                }
                generationState.upperLimit = generationState.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
                generationState.value = generationState.upperLimit.copy().subtract(this.incrementSize);
            } else if (!generationState.upperLimit.gt(generationState.value)) {
                generationState.lastSourceValue = callback.getNextValue();
                generationState.upperLimit = generationState.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
                generationState.value = generationState.upperLimit.copy().subtract(this.incrementSize);
            }
            Number number = generationState.value.makeValueThenIncrement();
            return number;
        }
        finally {
            this.lock.unlock();
        }
    }

    private GenerationState locateGenerationState(String tenantIdentifier) {
        GenerationState state;
        if (tenantIdentifier == null) {
            if (this.noTenantState == null) {
                this.noTenantState = new GenerationState();
            }
            return this.noTenantState;
        }
        if (this.tenantSpecificState == null) {
            this.tenantSpecificState = new ConcurrentHashMap<String, GenerationState>();
            state = new GenerationState();
            this.tenantSpecificState.put(tenantIdentifier, state);
        } else {
            state = this.tenantSpecificState.get(tenantIdentifier);
            if (state == null) {
                state = new GenerationState();
                this.tenantSpecificState.put(tenantIdentifier, state);
            }
        }
        return state;
    }

    private GenerationState noTenantGenerationState() {
        if (this.noTenantState == null) {
            throw new IllegalStateException("Could not locate previous generation state for no-tenant");
        }
        return this.noTenantState;
    }

    @Override
    public IntegralDataTypeHolder getLastSourceValue() {
        this.lock.lock();
        try {
            IntegralDataTypeHolder integralDataTypeHolder = this.noTenantGenerationState().lastSourceValue;
            return integralDataTypeHolder;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean applyIncrementSizeToSourceValues() {
        return false;
    }

    public IntegralDataTypeHolder getLastValue() {
        this.lock.lock();
        try {
            IntegralDataTypeHolder integralDataTypeHolder = this.noTenantGenerationState().value.copy().decrement();
            return integralDataTypeHolder;
        }
        finally {
            this.lock.unlock();
        }
    }

    public IntegralDataTypeHolder getHiValue() {
        this.lock.lock();
        try {
            IntegralDataTypeHolder integralDataTypeHolder = this.noTenantGenerationState().upperLimit;
            return integralDataTypeHolder;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Expression createLowValueExpression(Expression databaseValue, SessionFactoryImplementor sessionFactory) {
        BasicType<Integer> integerType = sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        return new BinaryArithmeticExpression(new BinaryArithmeticExpression(databaseValue, BinaryArithmeticOperator.MULTIPLY, new QueryLiteral<Integer>(this.incrementSize, integerType), integerType), BinaryArithmeticOperator.SUBTRACT, new QueryLiteral<Integer>(this.incrementSize - 1, integerType), integerType);
    }

    private static class GenerationState {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder upperLimit;
        private IntegralDataTypeHolder value;

        private GenerationState() {
        }
    }
}

