/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.TransactionState;

public class ListTransactionsOptions
extends AbstractOptions<ListTransactionsOptions> {
    private Set<TransactionState> filteredStates = Collections.emptySet();
    private Set<Long> filteredProducerIds = Collections.emptySet();
    private long filteredDuration = -1L;
    private String filteredTransactionalIdPattern;

    public ListTransactionsOptions filterStates(Collection<TransactionState> states) {
        this.filteredStates = new HashSet<TransactionState>(states);
        return this;
    }

    public ListTransactionsOptions filterProducerIds(Collection<Long> producerIdFilters) {
        this.filteredProducerIds = new HashSet<Long>(producerIdFilters);
        return this;
    }

    public ListTransactionsOptions filterOnDuration(long durationMs) {
        this.filteredDuration = durationMs;
        return this;
    }

    public ListTransactionsOptions filterOnTransactionalIdPattern(String pattern) {
        this.filteredTransactionalIdPattern = pattern;
        return this;
    }

    public Set<TransactionState> filteredStates() {
        return this.filteredStates;
    }

    public Set<Long> filteredProducerIds() {
        return this.filteredProducerIds;
    }

    public long filteredDuration() {
        return this.filteredDuration;
    }

    public String filteredTransactionalIdPattern() {
        return this.filteredTransactionalIdPattern;
    }

    public String toString() {
        return "ListTransactionsOptions(filteredStates=" + String.valueOf(this.filteredStates) + ", filteredProducerIds=" + String.valueOf(this.filteredProducerIds) + ", filteredDuration=" + this.filteredDuration + ", filteredTransactionalIdPattern=" + this.filteredTransactionalIdPattern + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTransactionsOptions that = (ListTransactionsOptions)o;
        return Objects.equals(this.filteredStates, that.filteredStates) && Objects.equals(this.filteredProducerIds, that.filteredProducerIds) && Objects.equals(this.filteredDuration, that.filteredDuration) && Objects.equals(this.filteredTransactionalIdPattern, that.filteredTransactionalIdPattern);
    }

    public int hashCode() {
        return Objects.hash(this.filteredStates, this.filteredProducerIds, this.filteredDuration, this.filteredTransactionalIdPattern);
    }
}

