/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.PathParameterCallbackUrlResolver;
import org.pac4j.core.util.HttpUtils;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.client.azuread.AzureAdResourceRetriever;
import org.pac4j.oidc.config.AzureAd2OidcConfiguration;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.exceptions.OidcTokenException;
import org.pac4j.oidc.profile.azuread.AzureAdProfile;
import org.pac4j.oidc.profile.azuread.AzureAdProfileCreator;

public class AzureAd2Client
extends OidcClient {
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected static final TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};

    public AzureAd2Client() {
    }

    public AzureAd2Client(AzureAd2OidcConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        this.getConfiguration().setResourceRetriever(new AzureAdResourceRetriever());
        this.setProfileCreatorIfUndefined(new AzureAdProfileCreator(this.getConfiguration(), this));
        super.internalInit(forceReinit);
    }

    protected CallbackUrlResolver newDefaultCallbackUrlResolver() {
        return new PathParameterCallbackUrlResolver();
    }

    public String getAccessTokenFromRefreshToken(AzureAdProfile azureAdProfile) {
        String string;
        AzureAd2OidcConfiguration azureConfig = (AzureAd2OidcConfiguration)this.getConfiguration();
        HttpURLConnection connection = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            headers.put("Accept", "application/json");
            URL tokenEndpointURL = ((OIDCProviderMetadata)azureConfig.getOpMetadataResolver().load()).getTokenEndpointURI().toURL();
            connection = HttpUtils.openPostConnection((URL)tokenEndpointURL, headers);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
            out.write(azureConfig.makeOauth2TokenRequest(azureAdProfile.getRefreshToken().getValue()));
            out.close();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new OidcTokenException("request for access token failed: " + HttpUtils.buildHttpErrorMessage((HttpURLConnection)connection));
            }
            String body = HttpUtils.readBody((HttpURLConnection)connection);
            Map res = (Map)this.objectMapper.readValue(body, typeRef);
            string = (String)res.get("access_token");
        }
        catch (IOException e) {
            try {
                throw new OidcException(e);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection((HttpURLConnection)connection);
        return string;
    }
}

