/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.security.Provider;
import java.security.Security;
import java.time.Duration;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStoreConfigurer;
import org.apereo.cas.authentication.attribute.DefaultAttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilderConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.audit.SamlMetadataResolverAuditResourceResolver;
import org.apereo.cas.support.saml.web.idp.audit.SamlRequestAuditResourceResolver;
import org.apereo.cas.support.saml.web.idp.audit.SamlResponseAuditPrincipalIdProvider;
import org.apereo.cas.support.saml.web.idp.audit.SamlResponseAuditResourceResolver;
import org.apereo.cas.support.saml.web.idp.profile.SamlSecurityProvider;
import org.apereo.cas.support.saml.web.idp.profile.artifact.CasSamlArtifactMap;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.assertion.SamlProfileSamlAssertionBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlProfileSamlAttributeStatementBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.SamlProfileAuthnContextClassRefBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.SamlProfileSamlAuthNStatementBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.conditions.SamlProfileSamlConditionsBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.DefaultSamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.nameid.SamlProfileSamlNameIdBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSaml2ResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.artifact.SamlProfileArtifactFaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.artifact.SamlProfileArtifactResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.query.SamlProfileAttributeQueryFaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.query.SamlProfileAttributeQueryResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11FaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11ResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.subject.SamlProfileSamlSubjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.artifact.DefaultSamlArtifactTicketFactory;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.query.DefaultSamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.soap.soap11.Envelope;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAMLIdentityProvider})
@Configuration(value="SamlIdPConfiguration", proxyBeanMethods=false)
class SamlIdPConfiguration {
    SamlIdPConfiguration() {
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.addProvider((Provider)new SamlSecurityProvider());
    }

    @Configuration(value="SamlIdPAttributeDefinitionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPAttributeDefinitionsConfiguration {
        SamlIdPAttributeDefinitionsConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"samlIdPAttributeDefinitionStoreConfigurer"})
        public AttributeDefinitionStoreConfigurer samlIdPAttributeDefinitionStoreConfigurer(CasConfigurationProperties casProperties) {
            return () -> DefaultAttributeDefinitionStore.from((Resource)new ClassPathResource("samlidp-attribute-definitions.json"));
        }
    }

    @Configuration(value="SamlIdPAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPAuditConfiguration {
        SamlIdPAuditConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlResponseAuditPrincipalIdProvider"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditPrincipalIdProvider samlResponseAuditPrincipalIdProvider() {
            return new SamlResponseAuditPrincipalIdProvider();
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlResponseAuditResourceResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver samlResponseAuditResourceResolver() {
            return new SamlResponseAuditResourceResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlRequestAuditResourceResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver samlRequestAuditResourceResolver() {
            return new SamlRequestAuditResourceResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlMetadataResolutionAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver samlMetadataResolutionAuditActionResolver() {
            return new DefaultAuditActionResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlMetadataResolutionAuditResourceResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver samlMetadataResolutionAuditResourceResolver() {
            return new SamlMetadataResolverAuditResourceResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlRequestAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver samlRequestAuditActionResolver() {
            return new DefaultAuditActionResolver("_CREATED", "_CREATED");
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlResponseAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver samlResponseAuditActionResolver() {
            return new DefaultAuditActionResolver("_CREATED", "_CREATED");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casSamlIdPAuditTrailRecordResolutionPlanConfigurer"})
        public AuditTrailRecordResolutionPlanConfigurer casSamlIdPAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="samlMetadataResolutionAuditResourceResolver") AuditResourceResolver samlMetadataResolutionAuditResourceResolver, @Qualifier(value="samlResponseAuditActionResolver") AuditActionResolver samlResponseAuditActionResolver, @Qualifier(value="samlRequestAuditActionResolver") AuditActionResolver samlRequestAuditActionResolver, @Qualifier(value="samlResponseAuditResourceResolver") AuditResourceResolver samlResponseAuditResourceResolver, @Qualifier(value="samlRequestAuditResourceResolver") AuditResourceResolver samlRequestAuditResourceResolver, @Qualifier(value="samlMetadataResolutionAuditActionResolver") AuditActionResolver samlMetadataResolutionAuditActionResolver) {
            return plan -> {
                plan.registerAuditResourceResolver("SAML2_RESPONSE_RESOURCE_RESOLVER", samlResponseAuditResourceResolver);
                plan.registerAuditActionResolver("SAML2_RESPONSE_ACTION_RESOLVER", samlResponseAuditActionResolver);
                plan.registerAuditResourceResolver("SAML2_REQUEST_RESOURCE_RESOLVER", samlRequestAuditResourceResolver);
                plan.registerAuditActionResolver("SAML2_REQUEST_ACTION_RESOLVER", samlRequestAuditActionResolver);
                plan.registerAuditResourceResolver("SAML2_METADATA_RESOLUTION_RESOURCE_RESOLVER", samlMetadataResolutionAuditResourceResolver);
                plan.registerAuditActionResolver("SAML2_METADATA_RESOLUTION_ACTION_RESOLVER", samlMetadataResolutionAuditActionResolver);
            };
        }
    }

    @Configuration(value="SamlIdPCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPCryptoConfiguration {
        SamlIdPCryptoConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlObjectEncrypter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPObjectEncrypter samlObjectEncrypter(@Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator, CasConfigurationProperties casProperties) {
            return new SamlIdPObjectEncrypter(casProperties.getAuthn().getSamlIdp(), samlIdPMetadataLocator);
        }

        @ConditionalOnMissingBean(name={"samlObjectSigner"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPObjectSigner samlObjectSigner(CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="samlIdPMetadataLocator") SamlIdPMetadataLocator samlIdPMetadataLocator) {
            return new DefaultSamlIdPObjectSigner(casSamlIdPMetadataResolver, casProperties, samlIdPMetadataLocator);
        }
    }

    @Configuration(value="SamlIdPLogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPLogoutConfiguration {
        SamlIdPLogoutConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlSingleLogoutServiceLogoutUrlBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilder samlSingleLogoutServiceLogoutUrlBuilder(@Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="urlValidator") UrlValidator urlValidator, CasConfigurationProperties casProperties) {
            return new SamlIdPSingleLogoutServiceLogoutUrlBuilder(servicesManager, defaultSamlRegisteredServiceCachingMetadataResolver, urlValidator, casProperties.getAuthn().getSamlIdp());
        }

        @ConditionalOnMissingBean(name={"samlSingleLogoutServiceLogoutUrlBuilderConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilderConfigurer samlSingleLogoutServiceLogoutUrlBuilderConfigurer(@Qualifier(value="samlSingleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder samlSingleLogoutServiceLogoutUrlBuilder) {
            return () -> samlSingleLogoutServiceLogoutUrlBuilder;
        }
    }

    @Configuration(value="SamlIdPTicketConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPTicketConfiguration {
        SamlIdPTicketConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlAttributeQueryTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory(@Qualifier(value="samlAttributeQueryTicketExpirationPolicy") ExpirationPolicyBuilder samlAttributeQueryTicketExpirationPolicy, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory) {
            return new DefaultSamlAttributeQueryTicketFactory(samlAttributeQueryTicketExpirationPolicy, samlIdPServiceFactory, openSamlConfigBean);
        }

        @ConditionalOnMissingBean(name={"samlArtifactTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlArtifactTicketFactory samlArtifactTicketFactory(@Qualifier(value="samlArtifactTicketExpirationPolicy") ExpirationPolicyBuilder samlArtifactTicketExpirationPolicy, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, @Qualifier(value="descendantTicketsTrackingPolicy") TicketTrackingPolicy descendantTicketsTrackingPolicy) {
            return new DefaultSamlArtifactTicketFactory(samlArtifactTicketExpirationPolicy, openSamlConfigBean, samlIdPServiceFactory, descendantTicketsTrackingPolicy);
        }

        @Bean(initMethod="initialize", destroyMethod="destroy")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SAMLArtifactMap samlArtifactMap(@Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="samlArtifactTicketExpirationPolicy") ExpirationPolicyBuilder samlArtifactTicketExpirationPolicy, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore) {
            CasSamlArtifactMap map = new CasSamlArtifactMap(ticketRegistry, ticketFactory, ticketGrantingTicketCookieGenerator, samlIdPDistributedSessionStore);
            ExpirationPolicy expirationPolicy = samlArtifactTicketExpirationPolicy.buildTicketExpirationPolicy();
            map.setArtifactLifetime(Duration.ofSeconds(expirationPolicy.getTimeToLive()));
            return map;
        }
    }

    @Configuration(value="SamlIdPTicketExpirationPolicyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPTicketExpirationPolicyConfiguration {
        SamlIdPTicketExpirationPolicyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlAttributeQueryTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder samlAttributeQueryTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new SamlAttributeQueryTicketExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"samlArtifactTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder samlArtifactTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new SamlArtifactTicketExpirationPolicyBuilder(casProperties);
        }
    }

    @Configuration(value="SamlIdPTicketFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPTicketFactoryPlanConfiguration {
        SamlIdPTicketFactoryPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlAttributeQueryTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer samlAttributeQueryTicketFactoryConfigurer(@Qualifier(value="samlAttributeQueryTicketFactory") SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory) {
            return () -> samlAttributeQueryTicketFactory;
        }

        @ConditionalOnMissingBean(name={"samlArtifactTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer samlArtifactTicketFactoryConfigurer(@Qualifier(value="samlArtifactTicketFactory") SamlArtifactTicketFactory samlArtifactTicketFactory) {
            return () -> samlArtifactTicketFactory;
        }
    }

    @Configuration(value="SamlIdPProfileBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPProfileBuilderConfiguration {
        SamlIdPProfileBuilderConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlResponseBuilderConfigurationContext"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Scope(value="prototype")
        public SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="velocityEngineFactory") VelocityEngine velocityEngineFactory, @Qualifier(value="samlProfileSamlAssertionBuilder") SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="samlIdPDistributedSessionStore") SessionStore samlIdPDistributedSessionStore, @Qualifier(value="samlArtifactMap") SAMLArtifactMap samlArtifactMap, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return SamlProfileSamlResponseBuilderConfigurationContext.builder().applicationContext(applicationContext).samlIdPMetadataResolver(casSamlIdPMetadataResolver).openSamlConfigBean(openSamlConfigBean).samlObjectSigner(samlObjectSigner).velocityEngineFactory(velocityEngineFactory).samlProfileSamlAssertionBuilder(samlProfileSamlAssertionBuilder).samlObjectEncrypter(samlObjectEncrypter).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).ticketRegistry(ticketRegistry).sessionStore(samlIdPDistributedSessionStore).samlArtifactMap(samlArtifactMap).centralAuthenticationService(centralAuthenticationService).casProperties(casProperties).ticketFactory(ticketFactory).build();
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAttributeQueryFaultResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Envelope> samlProfileSamlAttributeQueryFaultResponseBuilder(@Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<Response> samlProfileSamlResponseBuilder, @Qualifier(value="samlResponseBuilderConfigurationContext") SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
            return new SamlProfileAttributeQueryFaultResponseBuilder(samlResponseBuilderConfigurationContext.withSamlSoapResponseBuilder(samlProfileSamlResponseBuilder));
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAttributeQueryResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Envelope> samlProfileSamlAttributeQueryResponseBuilder(@Qualifier(value="samlProfileSamlResponseBuilder") SamlProfileObjectBuilder<Response> samlProfileSamlResponseBuilder, @Qualifier(value="samlResponseBuilderConfigurationContext") SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
            return new SamlProfileAttributeQueryResponseBuilder(samlResponseBuilderConfigurationContext.withSamlSoapResponseBuilder(samlProfileSamlResponseBuilder));
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlSubjectBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder(CasConfigurationProperties casProperties, @Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlSubjectBuilder(openSamlConfigBean, samlProfileSamlNameIdBuilder, casProperties, samlObjectEncrypter);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlSoap11FaultResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Envelope> samlProfileSamlSoap11FaultResponseBuilder(@Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="samlResponseBuilderConfigurationContext") SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
            return new SamlProfileSamlSoap11FaultResponseBuilder(samlResponseBuilderConfigurationContext.withSamlSoapResponseBuilder(samlProfileSamlNameIdBuilder));
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlSoap11ResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Envelope> samlProfileSamlSoap11ResponseBuilder(@Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="samlResponseBuilderConfigurationContext") SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
            return new SamlProfileSamlSoap11ResponseBuilder(samlResponseBuilderConfigurationContext.withSamlSoapResponseBuilder(samlProfileSamlNameIdBuilder));
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlArtifactFaultResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Envelope> samlProfileSamlArtifactFaultResponseBuilder(@Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="samlResponseBuilderConfigurationContext") SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
            return new SamlProfileArtifactFaultResponseBuilder(samlResponseBuilderConfigurationContext.withSamlSoapResponseBuilder(samlProfileSamlNameIdBuilder));
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlArtifactResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Envelope> samlProfileSamlArtifactResponseBuilder(@Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="samlResponseBuilderConfigurationContext") SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
            return new SamlProfileArtifactResponseBuilder(samlResponseBuilderConfigurationContext.withSamlSoapResponseBuilder(samlProfileSamlNameIdBuilder));
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlNameIdBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder(@Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibbolethCompatiblePersistentIdGenerator") PersistentIdGenerator shibbolethCompatiblePersistentIdGenerator, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter) {
            return new SamlProfileSamlNameIdBuilder(openSamlConfigBean, shibbolethCompatiblePersistentIdGenerator, casSamlIdPMetadataResolver, samlObjectEncrypter);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlConditionsBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlConditionsBuilder(openSamlConfigBean, casProperties);
        }

        @ConditionalOnMissingBean(name={"defaultAuthnContextClassRefBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<AuthnContext> defaultAuthnContextClassRefBuilder(@Qualifier(value="scriptResourceCacheManager") ObjectProvider<ScriptResourceCacheManager> scriptResourceCacheManager, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, CasConfigurationProperties casProperties) {
            return new SamlProfileAuthnContextClassRefBuilder(openSamlConfigBean, casSamlIdPMetadataResolver, casProperties, scriptResourceCacheManager);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAssertionBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder(@Qualifier(value="samlProfileSamlAuthNStatementBuilder") SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder, @Qualifier(value="samlProfileSamlAttributeStatementBuilder") SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder, @Qualifier(value="samlProfileSamlSubjectBuilder") SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder, @Qualifier(value="samlProfileSamlConditionsBuilder") SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder, @Qualifier(value="samlObjectSigner") SamlIdPObjectSigner samlObjectSigner, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlAssertionBuilder(openSamlConfigBean, samlProfileSamlAuthNStatementBuilder, samlProfileSamlAttributeStatementBuilder, samlProfileSamlSubjectBuilder, samlProfileSamlConditionsBuilder, samlObjectSigner, casSamlIdPMetadataResolver);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAuthNStatementBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder(CasConfigurationProperties casProperties, @Qualifier(value="defaultAuthnContextClassRefBuilder") SamlProfileObjectBuilder<AuthnContext> defaultAuthnContextClassRefBuilder, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new SamlProfileSamlAuthNStatementBuilder(openSamlConfigBean, defaultAuthnContextClassRefBuilder, casProperties);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlAttributeStatementBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder(CasConfigurationProperties casProperties, @Qualifier(value="samlObjectEncrypter") SamlIdPObjectEncrypter samlObjectEncrypter, @Qualifier(value="samlProfileSamlNameIdBuilder") SamlProfileObjectBuilder<SAMLObject> samlProfileSamlNameIdBuilder, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="casSamlIdPMetadataResolver") MetadataResolver casSamlIdPMetadataResolver) {
            return new SamlProfileSamlAttributeStatementBuilder(openSamlConfigBean, casProperties, samlObjectEncrypter, attributeDefinitionStore, samlIdPServiceFactory, samlProfileSamlNameIdBuilder, casSamlIdPMetadataResolver);
        }

        @ConditionalOnMissingBean(name={"samlProfileSamlResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlProfileObjectBuilder<Response> samlProfileSamlResponseBuilder(@Qualifier(value="samlResponseBuilderConfigurationContext") SamlProfileSamlResponseBuilderConfigurationContext samlResponseBuilderConfigurationContext) {
            return new SamlProfileSaml2ResponseBuilder(samlResponseBuilderConfigurationContext);
        }
    }
}

