/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class GroovyShellScript
implements ExecutableCompiledScript {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyShellScript.class);
    private static final ThreadLocal<Map<String, Object>> BINDING_THREAD_LOCAL = new ThreadLocal();
    private final CasReentrantLock lock = new CasReentrantLock();
    private final String script;
    private Script compiledScript;

    public <T> T execute(Object[] args, Class<T> clazz) throws Throwable {
        return this.execute(args, clazz, true);
    }

    public void execute(Object[] args) throws Throwable {
        this.execute(args, Void.class, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Object[] args, Class<T> clazz, boolean failOnError) {
        if (this.lock.tryLock()) {
            try {
                LOGGER.trace("Beginning to execute script [{}]", (Object)this);
                Map<String, Object> binding = BINDING_THREAD_LOCAL.get();
                if (this.compiledScript == null) {
                    this.compiledScript = ScriptingUtils.parseGroovyShellScript(binding, this.script);
                }
                if (binding != null && !binding.isEmpty()) {
                    LOGGER.trace("Setting binding [{}]", binding);
                    this.compiledScript.setBinding(new Binding(binding));
                }
                LOGGER.trace("Current binding [{}]", (Object)this.compiledScript.getBinding());
                T result = ScriptingUtils.executeGroovyShellScript(this.compiledScript, clazz);
                LOGGER.debug("Groovy script [{}] returns result [{}]", (Object)this, result);
                T t = result;
                return t;
            }
            catch (GroovyRuntimeException e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
            finally {
                BINDING_THREAD_LOCAL.remove();
                if (this.compiledScript != null) {
                    this.compiledScript.setBinding(new Binding(Map.of()));
                }
                LOGGER.trace("Completed script execution [{}]", (Object)this);
                this.lock.unlock();
            }
        }
        return null;
    }

    public <T> T execute(String methodName, Class<T> clazz, Object ... args) throws Throwable {
        return this.execute(args, clazz);
    }

    public void setBinding(Map<String, Object> args) {
        BINDING_THREAD_LOCAL.set(new HashMap<String, Object>(args));
    }

    public Resource getResource() {
        return new ByteArrayResource(this.script.getBytes(StandardCharsets.UTF_8));
    }

    @Generated
    public CasReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public Script getCompiledScript() {
        return this.compiledScript;
    }

    @Generated
    public GroovyShellScript(String script) {
        this.script = script;
    }

    @Generated
    public String toString() {
        return "GroovyShellScript(script=" + this.script + ")";
    }
}

