/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wsaddressing.MessageID;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.slf4j.Logger;

public class ExtractMessageIDHandler
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ExtractMessageIDHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        MessageID header = this.getMessageID(messageContext);
        String headerValue = header != null ? StringSupport.trimOrNull((String)header.getURI()) : null;
        this.log.debug("Extracted inbound WS-Addressing MessageID value: {}", (Object)headerValue);
        if (header != null && headerValue != null) {
            ((WSAddressingContext)messageContext.ensureSubcontext(WSAddressingContext.class)).setMessageIDURI(headerValue);
            SOAPMessagingSupport.registerUnderstoodHeader((MessageContext)messageContext, (XMLObject)header);
        }
    }

    protected MessageID getMessageID(@Nonnull MessageContext messageContext) {
        List messageIDs = SOAPMessagingSupport.getInboundHeaderBlock((MessageContext)messageContext, (QName)MessageID.ELEMENT_NAME);
        if (messageIDs != null && !messageIDs.isEmpty()) {
            return (MessageID)messageIDs.get(0);
        }
        return null;
    }
}

