/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import com.warrenstrange.googleauth.KeyRepresentation;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.device.MultifactorAuthenticationDeviceManager;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.MultifactorAuthenticationProviderMetadataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.CoreGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.GoogleAuthenticatorAuthenticationHandler;
import org.apereo.cas.gauth.GoogleAuthenticatorMultifactorAuthenticationProvider;
import org.apereo.cas.gauth.GoogleAuthenticatorService;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorOneTimeTokenCredentialValidator;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredentialRepositoryEndpoint;
import org.apereo.cas.gauth.credential.InMemoryGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.JsonGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.RestGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.gauth.token.GoogleAuthenticatorTokenRepositoryCleaner;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorAccountCheckRegistrationAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorDeleteAccountAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorPrepareLoginAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorSaveRegistrationAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorValidateSelectedRegistrationAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorValidateTokenAction;
import org.apereo.cas.gauth.web.flow.account.GoogleMultifactorAuthenticationAccountProfilePrepareAction;
import org.apereo.cas.gauth.web.flow.account.GoogleMultifactorAuthenticationAccountProfileRegistrationAction;
import org.apereo.cas.gauth.web.flow.account.GoogleMultifactorAuthenticationAccountProfileWebflowConfigurer;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenAccountCipherExecutor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenAccountSerializer;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialDeviceManager;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountConfirmSelectionRegistrationAction;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountCreateRegistrationAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.cipher.JasyptNumberCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.DefaultMultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GoogleAuthenticator})
@Configuration(value="GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration", proxyBeanMethods=false)
class GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration.class);

    GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration() {
    }

    @Configuration(value="GoogleAuthenticatorAccountProfileWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class GoogleAuthenticatorAccountProfileWebflowConfiguration {
        GoogleAuthenticatorAccountProfileWebflowConfiguration() {
        }

        @ConditionalOnMissingBean(name={"googleAccountProfileWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer googleAccountProfileWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new GoogleMultifactorAuthenticationAccountProfileWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer googleAccountCasWebflowExecutionPlanConfigurer(@Qualifier(value="googleAccountProfileWebflowConfigurer") CasWebflowConfigurer googleAccountProfileWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(googleAccountProfileWebflowConfigurer);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountDeviceProviderAction"})
        public MultifactorAuthenticationDeviceProviderAction googleAccountDeviceProviderAction(@Qualifier(value="googleAuthenticatorDeviceManager") MultifactorAuthenticationDeviceManager googleAuthenticatorDeviceManager) {
            return new DefaultMultifactorAuthenticationDeviceProviderAction(googleAuthenticatorDeviceManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountProfilePrepareAction"})
        public Action googleAccountProfilePrepareAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="googleAuthenticatorMultifactorAuthenticationProvider") MultifactorAuthenticationProvider googleAuthenticatorMultifactorAuthenticationProvider, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GoogleMultifactorAuthenticationAccountProfilePrepareAction(googleAuthenticatorAccountRegistry, googleAuthenticatorMultifactorAuthenticationProvider, casProperties)).withId("googleAccountProfilePrepareAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountProfileRegistrationAction"})
        public Action googleAccountProfileRegistrationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorMultifactorAuthenticationProvider") MultifactorAuthenticationProvider googleAuthenticatorMultifactorAuthenticationProvider) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GoogleMultifactorAuthenticationAccountProfileRegistrationAction(googleAuthenticatorMultifactorAuthenticationProvider)).withId("googleAccountProfileRegistrationAction").build().get();
        }
    }

    @Configuration(value="GoogleAuthenticatorMultifactorAuthenticationProviderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorMultifactorAuthenticationProviderConfiguration {
        GoogleAuthenticatorMultifactorAuthenticationProviderConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAuthenticatorMultifactorAuthenticationProvider"})
        public MultifactorAuthenticationProvider googleAuthenticatorMultifactorAuthenticationProvider(CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorBypassEvaluator, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator, @Qualifier(value="googleAuthenticatorDeviceManager") MultifactorAuthenticationDeviceManager googleAuthenticatorDeviceManager) {
            GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
            GoogleAuthenticatorMultifactorAuthenticationProvider provider = new GoogleAuthenticatorMultifactorAuthenticationProvider();
            provider.setBypassEvaluator(googleAuthenticatorBypassEvaluator);
            provider.setFailureMode(gauth.getFailureMode());
            provider.setFailureModeEvaluator(failureModeEvaluator);
            provider.setOrder(gauth.getRank());
            provider.setId(gauth.getId());
            provider.setDeviceManager(googleAuthenticatorDeviceManager);
            return provider;
        }
    }

    @Configuration(value="GoogleAuthenticatorMultifactorAuthenticationWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorMultifactorAuthenticationWebflowConfiguration {
        GoogleAuthenticatorMultifactorAuthenticationWebflowConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleValidateSelectedRegistrationAction"})
        public Action googleValidateSelectedRegistrationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(GoogleAuthenticatorValidateSelectedRegistrationAction::new).withId("googleValidateSelectedRegistrationAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleSaveAccountRegistrationAction"})
        public Action googleSaveAccountRegistrationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry, @Qualifier(value="googleAuthenticatorOneTimeTokenCredentialValidator") OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GoogleAuthenticatorSaveRegistrationAction(googleAuthenticatorAccountRegistry, casProperties, validator)).withId("googleSaveAccountRegistrationAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleValidateTokenAction"})
        public Action googleValidateTokenAction(@Qualifier(value="googleAuthenticatorOneTimeTokenCredentialValidator") OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> googleAuthenticatorOneTimeTokenCredentialValidator, ConfigurableApplicationContext applicationContext, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GoogleAuthenticatorValidateTokenAction(casProperties, googleAuthenticatorAccountRegistry, googleAuthenticatorOneTimeTokenCredentialValidator)).withId("googleValidateTokenAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"prepareGoogleAuthenticatorLoginAction"})
        public Action prepareGoogleAuthenticatorLoginAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GoogleAuthenticatorPrepareLoginAction(casProperties, googleAuthenticatorAccountRegistry)).withId("prepareGoogleAuthenticatorLoginAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountCheckRegistrationAction"})
        public Action googleAccountCheckRegistrationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GoogleAuthenticatorAccountCheckRegistrationAction(googleAuthenticatorAccountRegistry, casProperties)).withId("googleAccountCheckRegistrationAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountConfirmSelectionAction"})
        public Action googleAccountConfirmSelectionAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new OneTimeTokenAccountConfirmSelectionRegistrationAction(googleAuthenticatorAccountRegistry)).withId("googleAccountConfirmSelectionAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountDeleteDeviceAction"})
        public Action googleAccountDeleteDeviceAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GoogleAuthenticatorDeleteAccountAction(googleAuthenticatorAccountRegistry)).withId("googleAccountDeleteDeviceAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAccountCreateRegistrationAction"})
        public Action googleAccountCreateRegistrationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry) {
            CoreGoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth().getCore();
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new OneTimeTokenAccountCreateRegistrationAction(googleAuthenticatorAccountRegistry, gauth.getLabel(), gauth.getIssuer())).withId("googleAccountCreateRegistrationAction").build().get();
        }
    }

    @Configuration(value="GoogleAuthenticatorMultifactorAuthenticationTokenConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorMultifactorAuthenticationTokenConfiguration {
        GoogleAuthenticatorMultifactorAuthenticationTokenConfiguration() {
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorOneTimeTokenCredentialValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> googleAuthenticatorOneTimeTokenCredentialValidator(@Qualifier(value="googleAuthenticatorInstance") IGoogleAuthenticator googleAuthenticatorInstance, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry, @Qualifier(value="oneTimeTokenAuthenticatorTokenRepository") OneTimeTokenRepository oneTimeTokenAuthenticatorTokenRepository) {
            return new GoogleAuthenticatorOneTimeTokenCredentialValidator(googleAuthenticatorInstance, oneTimeTokenAuthenticatorTokenRepository, googleAuthenticatorAccountRegistry);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Cleanable googleAuthenticatorTokenRepositoryCleaner(ConfigurableApplicationContext applicationContext, @Qualifier(value="oneTimeTokenAuthenticatorTokenRepository") OneTimeTokenRepository repository) {
            return (Cleanable)BeanSupplier.of(Cleanable.class).when(BeanCondition.on((String)"cas.authn.mfa.gauth.cleaner.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new GoogleAuthenticatorTokenRepositoryCleaner(repository)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorDeviceManager"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationDeviceManager googleAuthenticatorDeviceManager(@Qualifier(value="googleAuthenticatorMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> googleAuthenticatorMultifactorAuthenticationProvider, @Qualifier(value="googleAuthenticatorAccountRegistry") OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry) {
            return new OneTimeTokenCredentialDeviceManager(googleAuthenticatorAccountRegistry, googleAuthenticatorMultifactorAuthenticationProvider);
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorAccountRegistry"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorInstance") IGoogleAuthenticator googleAuthenticatorInstance, @Qualifier(value="googleAuthenticatorAccountCipherExecutor") CipherExecutor googleAuthenticatorAccountCipherExecutor, @Qualifier(value="googleAuthenticatorScratchCodesCipherExecutor") CipherExecutor googleAuthenticatorScratchCodesCipherExecutor) {
            GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
            if (gauth.getJson().getLocation() != null) {
                return new JsonGoogleAuthenticatorTokenCredentialRepository(gauth.getJson().getLocation(), googleAuthenticatorInstance, googleAuthenticatorAccountCipherExecutor, googleAuthenticatorScratchCodesCipherExecutor, (StringSerializer)new OneTimeTokenAccountSerializer(applicationContext));
            }
            if (StringUtils.isNotBlank((CharSequence)gauth.getRest().getUrl())) {
                return new RestGoogleAuthenticatorTokenCredentialRepository(googleAuthenticatorInstance, gauth, googleAuthenticatorAccountCipherExecutor, googleAuthenticatorScratchCodesCipherExecutor);
            }
            return new InMemoryGoogleAuthenticatorTokenCredentialRepository(googleAuthenticatorAccountCipherExecutor, googleAuthenticatorScratchCodesCipherExecutor, googleAuthenticatorInstance);
        }
    }

    @Configuration(value="GoogleAuthenticatorMultifactorAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorMultifactorAuthenticationPlanConfiguration {
        GoogleAuthenticatorMultifactorAuthenticationPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer googleAuthenticatorAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="googleAuthenticatorMultifactorProviderAuthenticationMetadataPopulator") AuthenticationMetaDataPopulator googleAuthenticatorMultifactorProviderAuthenticationMetadataPopulator, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAuthenticationHandler") AuthenticationHandler googleAuthenticatorAuthenticationHandler, @Qualifier(value="googleAuthenticatorAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator googleAuthenticatorAuthenticationMetaDataPopulator) {
            return plan -> {
                if (StringUtils.isNotBlank((CharSequence)casProperties.getAuthn().getMfa().getGauth().getCore().getIssuer())) {
                    plan.registerAuthenticationHandler(googleAuthenticatorAuthenticationHandler);
                    plan.registerAuthenticationMetadataPopulator(googleAuthenticatorAuthenticationMetaDataPopulator);
                    plan.registerAuthenticationMetadataPopulator(googleAuthenticatorMultifactorProviderAuthenticationMetadataPopulator);
                    plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{GoogleAuthenticatorTokenCredential.class}));
                }
            };
        }
    }

    @Configuration(value="GoogleAuthenticatorMultifactorAuthenticationWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorMultifactorAuthenticationWebConfiguration {
        GoogleAuthenticatorMultifactorAuthenticationWebConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public GoogleAuthenticatorTokenCredentialRepositoryEndpoint googleAuthenticatorTokenCredentialRepositoryEndpoint(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountRegistry") ObjectProvider<OneTimeTokenCredentialRepository> googleAuthenticatorAccountRegistry) {
            return new GoogleAuthenticatorTokenCredentialRepositoryEndpoint(casProperties, applicationContext, googleAuthenticatorAccountRegistry);
        }
    }

    @Configuration(value="GoogleAuthenticatorAuthenticationEventExecutionPlanMetadataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorAuthenticationEventExecutionPlanMetadataConfiguration {
        GoogleAuthenticatorAuthenticationEventExecutionPlanMetadataConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationMetaDataPopulator"})
        public AuthenticationMetaDataPopulator googleAuthenticatorAuthenticationMetaDataPopulator(CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAuthenticationHandler") AuthenticationHandler googleAuthenticatorAuthenticationHandler, @Qualifier(value="googleAuthenticatorMultifactorAuthenticationProvider") MultifactorAuthenticationProvider googleAuthenticatorMultifactorAuthenticationProvider) {
            return new AuthenticationContextAttributeMetaDataPopulator(casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute(), googleAuthenticatorAuthenticationHandler, googleAuthenticatorMultifactorAuthenticationProvider.getId());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"googleAuthenticatorMultifactorProviderAuthenticationMetadataPopulator"})
        public AuthenticationMetaDataPopulator googleAuthenticatorMultifactorProviderAuthenticationMetadataPopulator(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
            String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
            return new MultifactorAuthenticationProviderMetadataPopulator(authenticationContextAttribute, multifactorAuthenticationProvider, servicesManager);
        }
    }

    @Configuration(value="GoogleAuthenticatorMultifactorAuthenticationCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorMultifactorAuthenticationCoreConfiguration {
        private static final BeanCondition CONDITION_SCRATCH_CODE = BeanCondition.on((String)"cas.authn.mfa.gauth.core.scratch-codes.encryption.key");

        GoogleAuthenticatorMultifactorAuthenticationCoreConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"googleAuthenticatorInstance"})
        public IGoogleAuthenticator googleAuthenticatorInstance(CasConfigurationProperties casProperties) {
            CoreGoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth().getCore();
            GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder bldr = new GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder();
            bldr.setCodeDigits(gauth.getCodeDigits());
            bldr.setTimeStepSizeInMillis(TimeUnit.SECONDS.toMillis(gauth.getTimeStepSize()));
            bldr.setWindowSize(gauth.getWindowSize());
            bldr.setKeyRepresentation(KeyRepresentation.BASE32);
            return new GoogleAuthenticatorService(new GoogleAuthenticator(bldr.build()));
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorAccountCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor googleAuthenticatorAccountCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getMfa().getGauth().getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, OneTimeTokenAccountCipherExecutor.class);
            }
            LOGGER.warn("Google Authenticator one-time token account encryption/signing is turned off. Consider turning on encryption, signing to securely and safely store one-time token accounts.");
            return CipherExecutor.noOp();
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorScratchCodesCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor googleAuthenticatorScratchCodesCipherExecutor(ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (CipherExecutor)BeanSupplier.of(CipherExecutor.class).when(CONDITION_SCRATCH_CODE.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                String key = casProperties.getAuthn().getMfa().getGauth().getCore().getScratchCodes().getEncryption().getKey();
                return new JasyptNumberCipherExecutor(key, "googleAuthenticatorScratchCodesCipherExecutor");
            }).otherwise(() -> {
                LOGGER.warn("Google Authenticator scratch codes encryption key is not defined. Consider defining the encryption key to securely and safely store scratch codes.");
                return CipherExecutor.noOp();
            }).get();
        }

        @ConditionalOnMissingBean(name={"googlePrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory googlePrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="GoogleAuthenticatorAuthenticationEventExecutionPlaHandlerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GoogleAuthenticatorAuthenticationEventExecutionPlaHandlerConfiguration {
        GoogleAuthenticatorAuthenticationEventExecutionPlaHandlerConfiguration() {
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationHandler googleAuthenticatorAuthenticationHandler(@Qualifier(value="googleAuthenticatorMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider, CasConfigurationProperties casProperties, @Qualifier(value="googlePrincipalFactory") PrincipalFactory googlePrincipalFactory, @Qualifier(value="googleAuthenticatorOneTimeTokenCredentialValidator") OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> googleAuthenticatorOneTimeTokenCredentialValidator, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
            return new GoogleAuthenticatorAuthenticationHandler(gauth.getName(), servicesManager, googlePrincipalFactory, googleAuthenticatorOneTimeTokenCredentialValidator, Integer.valueOf(gauth.getOrder()), multifactorAuthenticationProvider);
        }
    }
}

