/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.task.InboundTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class ConnObjectUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnObjectUtils.class);
    protected final TemplateUtils templateUtils;
    protected final RealmSearchDAO realmSearchDAO;
    protected final UserDAO userDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final PasswordGenerator passwordGenerator;
    protected final MappingManager mappingManager;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final EncryptorManager encryptorManager;

    public static SyncToken toSyncToken(String syncToken) {
        return Optional.ofNullable(syncToken).map(st -> (SyncToken)POJOHelper.deserialize((String)st, SyncToken.class)).orElse(null);
    }

    public static String toString(SyncToken syncToken) {
        return Optional.ofNullable(syncToken).map(POJOHelper::serialize).orElse(null);
    }

    public static String getPassword(Object pwd) {
        StringBuilder result = new StringBuilder();
        Object object = pwd;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuardedString.class, GuardedByteArray.class, String.class}, (Object)object2, n)) {
            case 0: {
                GuardedString guardedString = (GuardedString)object2;
                result.append(SecurityUtil.decrypt((GuardedString)guardedString));
                break;
            }
            case 1: {
                GuardedByteArray guardedByteArray = (GuardedByteArray)object2;
                result.append(Arrays.toString(SecurityUtil.decrypt((GuardedByteArray)guardedByteArray)));
                break;
            }
            case 2: {
                String string = (String)object2;
                result.append(string);
                break;
            }
            default: {
                result.append(pwd);
            }
        }
        return result.toString();
    }

    public static ConnObject getConnObjectTO(String fiql, Set<Attribute> attrs) {
        ConnObject connObjectTO = new ConnObject();
        connObjectTO.setFiql(fiql);
        if (!CollectionUtils.isEmpty(attrs)) {
            connObjectTO.getAttrs().addAll(attrs.stream().map(attr -> {
                Attr attrTO = new Attr();
                attrTO.setSchema(attr.getName());
                if (!CollectionUtils.isEmpty((Collection)attr.getValue())) {
                    attr.getValue().stream().filter(Objects::nonNull).forEach(value -> {
                        if (value instanceof GuardedString || value instanceof GuardedByteArray) {
                            attrTO.getValues().add(ConnObjectUtils.getPassword(value));
                        } else if (value instanceof byte[]) {
                            byte[] bytea = (byte[])value;
                            attrTO.getValues().add(Base64.getEncoder().encodeToString(bytea));
                        } else {
                            attrTO.getValues().add(value.toString());
                        }
                    });
                }
                return attrTO;
            }).toList());
        }
        return connObjectTO;
    }

    public ConnObjectUtils(TemplateUtils templateUtils, RealmSearchDAO realmSearchDAO, UserDAO userDAO, ExternalResourceDAO resourceDAO, PasswordGenerator passwordGenerator, MappingManager mappingManager, AnyUtilsFactory anyUtilsFactory, EncryptorManager encryptorManager) {
        this.templateUtils = templateUtils;
        this.realmSearchDAO = realmSearchDAO;
        this.userDAO = userDAO;
        this.resourceDAO = resourceDAO;
        this.passwordGenerator = passwordGenerator;
        this.mappingManager = mappingManager;
        this.anyUtilsFactory = anyUtilsFactory;
        this.encryptorManager = encryptorManager;
    }

    @Transactional(readOnly=true)
    public <C extends AnyCR> C getAnyCR(ConnectorObject obj, InboundTask<?> inboundTask, AnyTypeKind anyTypeKind, Provision provision, boolean generatePassword) {
        UserCR userCR;
        Object anyTO = this.getAnyTOFromConnObject(obj, inboundTask, anyTypeKind, provision);
        AnyCR anyCR = this.anyUtilsFactory.getInstance(anyTypeKind).newAnyCR();
        EntityTOUtils.toAnyCR(anyTO, (AnyCR)anyCR);
        if (anyCR instanceof UserCR && StringUtils.isBlank((CharSequence)(userCR = (UserCR)anyCR).getPassword()) && generatePassword) {
            ArrayList passwordPolicies = new ArrayList();
            userCR.getResources().stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).findById(arg_0)).flatMap(Optional::stream).filter(r -> r.getPasswordPolicy() != null).forEach(r -> passwordPolicies.add(r.getPasswordPolicy()));
            this.realmSearchDAO.findByFullPath(userCR.getRealm()).ifPresent(realm -> this.realmSearchDAO.findAncestors(realm).stream().filter(ancestor -> ancestor.getPasswordPolicy() != null && !passwordPolicies.contains(ancestor.getPasswordPolicy())).forEach(ancestor -> passwordPolicies.add(ancestor.getPasswordPolicy())));
            userCR.setPassword(this.passwordGenerator.generate(passwordPolicies));
        }
        return (C)anyCR;
    }

    public RealmTO getRealmTO(ConnectorObject obj, OrgUnit orgUnit) {
        RealmTO realmTO = new RealmTO();
        MappingUtils.getInboundItems(orgUnit.getItems().stream()).forEach(item -> this.mappingManager.setIntValues(item, obj.getAttributeByName(item.getExtAttrName()), realmTO));
        return realmTO;
    }

    @Transactional(readOnly=true)
    public <U extends AnyUR> U getAnyUR(String key, ConnectorObject obj, AnyTO original, InboundTask<?> inboundTask, AnyTypeKind anyTypeKind, Provision provision) {
        Object updated = this.getAnyTOFromConnObject(obj, inboundTask, anyTypeKind, provision);
        updated.setKey(key);
        AnyObjectUR anyUR = switch (provision.getAnyType()) {
            case "USER" -> {
                UserTO originalUser = (UserTO)original;
                UserTO updatedUser = (UserTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedUser.getUsername())) {
                    updatedUser.setUsername(originalUser.getUsername());
                }
                User user = (User)this.userDAO.authFind(key);
                if (StringUtils.isBlank((CharSequence)updatedUser.getPassword()) || this.encryptorManager.getInstance().verify(updatedUser.getPassword(), user.getCipherAlgorithm(), user.getPassword())) {
                    updatedUser.setPassword(null);
                }
                updatedUser.setSecurityQuestion(originalUser.getSecurityQuestion());
                if (!this.mappingManager.hasMustChangePassword(provision)) {
                    updatedUser.setMustChangePassword(originalUser.isMustChangePassword());
                }
                yield AnyOperations.diff((UserTO)updatedUser, (UserTO)originalUser, (boolean)true);
            }
            case "GROUP" -> {
                GroupTO originalGroup = (GroupTO)original;
                GroupTO updatedGroup = (GroupTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedGroup.getName())) {
                    updatedGroup.setName(originalGroup.getName());
                }
                updatedGroup.setUserOwner(originalGroup.getUserOwner());
                updatedGroup.setGroupOwner(originalGroup.getGroupOwner());
                updatedGroup.setUDynMembershipCond(originalGroup.getUDynMembershipCond());
                updatedGroup.getADynMembershipConds().putAll(originalGroup.getADynMembershipConds());
                updatedGroup.getTypeExtensions().addAll(originalGroup.getTypeExtensions());
                yield AnyOperations.diff((GroupTO)updatedGroup, (GroupTO)originalGroup, (boolean)true);
            }
            default -> {
                AnyObjectTO originalAnyObject = (AnyObjectTO)original;
                AnyObjectTO updatedAnyObject = (AnyObjectTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedAnyObject.getName())) {
                    updatedAnyObject.setName(originalAnyObject.getName());
                }
                yield AnyOperations.diff((AnyObjectTO)updatedAnyObject, (AnyObjectTO)originalAnyObject, (boolean)true);
            }
        };
        if (anyUR != null) {
            anyUR.setRealm(null);
            AnyOperations.cleanEmptyAttrs(updated, (AnyUR)anyUR);
        }
        return (U)anyUR;
    }

    protected <T extends AnyTO> T getAnyTOFromConnObject(ConnectorObject obj, InboundTask<?> inboundTask, AnyTypeKind anyTypeKind, Provision provision) {
        AnyTO anyTO = this.anyUtilsFactory.getInstance(anyTypeKind).newAnyTO();
        anyTO.setType(provision.getAnyType());
        anyTO.getAuxClasses().addAll(provision.getAuxClasses());
        anyTO.setRealm(inboundTask.getDestinationRealm().getFullPath());
        MappingUtils.getInboundItems(provision.getMapping().getItems().stream()).forEach(item -> this.mappingManager.setIntValues(item, obj.getAttributeByName(item.getExtAttrName()), anyTO));
        inboundTask.getTemplate(provision.getAnyType()).ifPresent(template -> this.templateUtils.apply((RealmMember)anyTO, template.get()));
        return (T)anyTO;
    }
}

