/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.java.job.AfterHandlingJob;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPushResultHandler
extends AbstractSyncopeResultHandler<PushTask, PushActions>
implements SyncopePushResultHandler {
    @Autowired
    protected OutboundMatcher outboundMatcher;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected MappingManager mappingManager;
    @Autowired
    protected SyncopeTaskScheduler scheduler;

    protected static void reportPropagation(ProvisioningReport result, PropagationReporter reporter) {
        if (!reporter.getStatuses().isEmpty()) {
            result.setStatus(AbstractPushResultHandler.toProvisioningReportStatus(((PropagationStatus)reporter.getStatuses().getFirst()).getStatus()));
            result.setMessage(((PropagationStatus)reporter.getStatuses().getFirst()).getFailureReason());
        }
    }

    protected static ResourceOperation toResourceOperation(UnmatchingRule rule) {
        return switch (rule) {
            case UnmatchingRule.ASSIGN, UnmatchingRule.PROVISION -> ResourceOperation.CREATE;
            default -> ResourceOperation.NONE;
        };
    }

    protected static ResourceOperation toResourceOperation(MatchingRule rule) {
        return switch (rule) {
            case MatchingRule.UPDATE -> ResourceOperation.UPDATE;
            case MatchingRule.DEPROVISION, MatchingRule.UNASSIGN -> ResourceOperation.DELETE;
            default -> ResourceOperation.NONE;
        };
    }

    protected static ProvisioningReport.Status toProvisioningReportStatus(ExecStatus status) {
        switch (status) {
            case FAILURE: {
                return ProvisioningReport.Status.FAILURE;
            }
            case SUCCESS: {
                return ProvisioningReport.Status.SUCCESS;
            }
        }
        return ProvisioningReport.Status.IGNORE;
    }

    protected abstract String getName(Any var1);

    protected void update(Any any, Boolean enable, ConnectorObject beforeObj, ProvisioningReport result) {
        List<String> ownedResources = this.getAnyUtils().getAllResources(any).stream().map(Entity::getKey).toList();
        ArrayList<String> noPropResources = new ArrayList<String>(ownedResources);
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)((PushTask)this.profile.getTask()).getResource().getKey()));
        propByRes.addOldConnObjectKey(((PushTask)this.profile.getTask()).getResource().getKey(), beforeObj.getUid().getUidValue());
        List taskInfos = this.propagationManager.getUpdateTasks(null, any.getType().getKind(), any.getKey(), any instanceof User ? List.of(((PushTask)this.profile.getTask()).getResource().getKey()) : List.of(), enable, propByRes, null, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.getFirst()).setBeforeObj(Optional.of(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.getFirst(), (PropagationReporter)reporter, this.securityProperties.getAdminUser());
            AbstractPushResultHandler.reportPropagation(result, reporter);
        }
    }

    protected void deprovision(Any any, ConnectorObject beforeObj, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any);
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)((PushTask)this.profile.getTask()).getResource().getKey()));
        propByRes.addOldConnObjectKey(((PushTask)this.profile.getTask()).getResource().getKey(), beforeObj.getUid().getUidValue());
        List taskInfos = this.propagationManager.getDeleteTasks(any.getType().getKind(), any.getKey(), propByRes, null, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.getFirst()).setBeforeObj(Optional.of(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.getFirst(), (PropagationReporter)reporter, this.securityProperties.getAdminUser());
            AbstractPushResultHandler.reportPropagation(result, reporter);
        }
    }

    protected void provision(Any any, Boolean enable, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any);
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)((PushTask)this.profile.getTask()).getResource().getKey()));
        List taskInfos = this.propagationManager.getCreateTasks(any.getType().getKind(), any.getKey(), enable, propByRes, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.getFirst()).setBeforeObj(Optional.empty());
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.getFirst(), (PropagationReporter)reporter, this.securityProperties.getAdminUser());
            AbstractPushResultHandler.reportPropagation(result, reporter);
        }
    }

    protected void copyDynMembershipConds(Any any, AnyUR req) {
        if (any instanceof Group) {
            Group group = (Group)any;
            if (req instanceof GroupUR) {
                GroupUR gur = (GroupUR)req;
                Optional.ofNullable(group.getUDynMembership()).ifPresent(udc -> gur.setUDynMembershipCond(udc.getFIQLCond()));
                group.getADynMemberships().forEach(adc -> gur.getADynMembershipConds().put(adc.getAnyType().getKey(), adc.getFIQLCond()));
            }
        }
    }

    protected void link(Any any, boolean unlink, ProvisioningReport result) {
        AnyUR req = this.getAnyUtils().newAnyUR(any.getKey());
        req.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.copyDynMembershipConds(any, req);
        this.update(req);
        result.setStatus(ProvisioningReport.Status.SUCCESS);
    }

    protected void unassign(Any any, ConnectorObject beforeObj, ProvisioningReport result) {
        AnyUR req = this.getAnyUtils().newAnyUR(any.getKey());
        req.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.copyDynMembershipConds(any, req);
        this.update(req);
        this.deprovision(any, beforeObj, result);
    }

    protected void assign(Any any, Boolean enabled, ProvisioningReport result) {
        AnyUR req = this.getAnyUtils().newAnyUR(any.getKey());
        req.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.copyDynMembershipConds(any, req);
        this.update(req);
        this.provision(any, enabled, result);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean handle(String anyKey) {
        Any any = null;
        try {
            any = this.getAnyUtils().dao().authFind(anyKey);
            Provision provision = ((PushTask)this.profile.getTask()).getResource().getProvisionByAnyType(any.getType().getKey()).orElse(null);
            if (provision == null) {
                throw new JobExecutionException("No provision found on " + String.valueOf(((PushTask)this.profile.getTask()).getResource()) + " for " + any.getType().getKey());
            }
            this.doHandle(any, provision);
            if (this.stopRequested) {
                LOG.debug("Stop was requested");
                return false;
            }
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = this.profile.getResults().stream().filter(report -> anyKey.equalsIgnoreCase(report.getKey())).findFirst().orElse(null);
            if (ignoreResult == null) {
                ignoreResult = new ProvisioningReport();
                ignoreResult.setKey(anyKey);
                ignoreResult.setAnyType((String)Optional.ofNullable(any).map(any1 -> any1.getType().getKey()).orElse(null));
                this.profile.getResults().add(ignoreResult);
            }
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setMessage(e.getMessage());
            LOG.warn("Ignoring during push", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Push failed", (Throwable)e);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doHandle(Any any, Provision provision) throws JobExecutionException {
        result = new ProvisioningReport();
        this.profile.getResults().add(result);
        result.setKey(any.getKey());
        result.setAnyType(any.getType().getKey());
        result.setName(this.getName(any));
        AbstractPushResultHandler.LOG.debug("Pushing {} with key {} towards {}", new Object[]{any.getType().getKind(), any.getKey(), ((PushTask)this.profile.getTask()).getResource()});
        moreAttrsToGet = new HashSet<E>();
        this.profile.getActions().forEach((Consumer<PushActions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doHandle$4(java.util.Set org.apache.syncope.core.persistence.api.entity.Any org.apache.syncope.core.provisioning.api.pushpull.PushActions ), (Lorg/apache/syncope/core/provisioning/api/pushpull/PushActions;)V)((AbstractPushResultHandler)this, moreAttrsToGet, (Any)any));
        connObjs = this.outboundMatcher.match(this.profile.getConnector(), any, ((PushTask)this.profile.getTask()).getResource(), provision, Optional.of((String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doHandle$5(int ), (I)[Ljava/lang/String;)())));
        AbstractPushResultHandler.LOG.debug("Match(es) found for {} as {}: {}", new Object[]{any, provision.getObjectClass(), connObjs});
        if (connObjs.size() > 1) {
            switch (1.$SwitchMap$org$apache$syncope$common$lib$types$ConflictResolutionAction[this.profile.getConflictResolutionAction().ordinal()]) {
                case 1: {
                    throw new IgnoreProvisionException("More than one match found for " + any.getKey() + ": " + String.valueOf(connObjs));
                }
                case 2: {
                    connObjs = connObjs.subList(0, 1);
                    break;
                }
                case 3: {
                    connObjs = connObjs.subList(connObjs.size() - 1, connObjs.size());
                    break;
                }
            }
        }
        v0 = beforeObj = connObjs.isEmpty() != false ? null : connObjs.getFirst();
        if (this.profile.isDryRun()) {
            if (beforeObj == null) {
                result.setOperation(AbstractPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
            } else {
                result.setOperation(AbstractPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            return;
        }
        operation = beforeObj == null ? UnmatchingRule.toOp((UnmatchingRule)((PushTask)this.profile.getTask()).getUnmatchingRule()) : MatchingRule.toOp((MatchingRule)((PushTask)this.profile.getTask()).getMatchingRule());
        notificationsAvailable = this.notificationManager.notificationsAvailable(AuthContextUtils.getDomain(), OpEvent.CategoryType.PUSH, any.getType().getKind().name(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        auditRequested = this.auditManager.auditRequested(AuthContextUtils.getDomain(), AuthContextUtils.getUsername(), OpEvent.CategoryType.PUSH, any.getType().getKind().name(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        output = null;
        resultStatus = null;
        if (!(any instanceof User)) ** GOTO lbl-1000
        user = (User)any;
        if (((PushTask)this.profile.getTask()).isSyncStatus()) {
            v1 = BooleanUtils.negate((Boolean)user.isSuspended());
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        enable = v1;
        try {
            if (beforeObj == null) {
                result.setOperation(AbstractPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$UnmatchingRule[((PushTask)this.profile.getTask()).getUnmatchingRule().ordinal()]) {
                    case 1: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeAssign(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.assign(any, enable, result);
                        break;
                    }
                    case 2: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeProvision(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.provision(any, enable, result);
                        break;
                    }
                    case 3: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, true, result);
                        break;
                    }
                    case 4: {
                        AbstractPushResultHandler.LOG.debug("Ignored any: {}", (Object)any);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            } else {
                result.setOperation(AbstractPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$MatchingRule[((PushTask)this.profile.getTask()).getMatchingRule().ordinal()]) {
                    case 1: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.update(any, enable, beforeObj, result);
                        break;
                    }
                    case 2: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.deprovision(any, beforeObj, result);
                        break;
                    }
                    case 3: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.unassign(any, beforeObj, result);
                        break;
                    }
                    case 4: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, false, result);
                        break;
                    }
                    case 5: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, (Entity)any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            AbstractPushResultHandler.LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, true, result);
                        break;
                    }
                    case 6: {
                        AbstractPushResultHandler.LOG.debug("Ignored any: {}", (Object)any);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            }
            for (PushActions action : this.profile.getActions()) {
                action.after(this.profile, (Entity)any, result);
            }
            if (result.getStatus() == null) {
                result.setStatus(ProvisioningReport.Status.SUCCESS);
            }
            if (notificationsAvailable || auditRequested) {
                resultStatus = OpEvent.Outcome.SUCCESS;
                output = this.outboundMatcher.match(this.profile.getConnector(), any, ((PushTask)this.profile.getTask()).getResource(), provision, Optional.of((String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doHandle$6(int ), (I)[Ljava/lang/String;)())));
            }
            if (!notificationsAvailable) {
                if (auditRequested == false) return;
            }
            jobMap = new HashMap<String, Object>();
        }
        catch (IgnoreProvisionException e) {
            try {
                throw e;
                catch (Exception e) {
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    if (notificationsAvailable || auditRequested) {
                        resultStatus = OpEvent.Outcome.FAILURE;
                        output = e;
                    }
                    AbstractPushResultHandler.LOG.warn("Error pushing {} towards {}", new Object[]{any, ((PushTask)this.profile.getTask()).getResource(), e});
                    var14_17 = this.profile.getActions().iterator();
                    while (var14_17.hasNext() != false) {
                        action = (PushActions)var14_17.next();
                        action.onError(this.profile, (Entity)any, result, e);
                    }
                    throw new JobExecutionException((Throwable)e);
                }
            }
            catch (Throwable var16_19) {
                if (!notificationsAvailable) {
                    if (auditRequested == false) throw var16_19;
                }
                jobMap = new HashMap<String, Object>();
                jobMap.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getDomain(), AuthContextUtils.getWho(), OpEvent.CategoryType.PUSH, any.getType().getKind().name(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, output, new Object[]{this.getAnyTO(any)}));
                AfterHandlingJob.schedule(this.scheduler, jobMap);
                throw var16_19;
            }
        }
        jobMap.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getDomain(), AuthContextUtils.getWho(), OpEvent.CategoryType.PUSH, any.getType().getKind().name(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, output, new Object[]{this.getAnyTO(any)}));
        AfterHandlingJob.schedule(this.scheduler, jobMap);
    }

    private static /* synthetic */ String[] lambda$doHandle$6(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$doHandle$5(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doHandle$4(Set moreAttrsToGet, Any any, PushActions action) {
        moreAttrsToGet.addAll(action.moreAttrsToGet(this.profile, (Entity)any));
    }
}

