/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.policy.AccessPolicyTO;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.AuthPolicyTO;
import org.apache.syncope.common.lib.policy.InboundPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.PropagationPolicyTO;
import org.apache.syncope.common.lib.policy.PushPolicyTO;
import org.apache.syncope.common.lib.policy.TicketExpirationPolicyTO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.InboundCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.policy.InboundPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyDataBinderImpl
implements PolicyDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(PolicyDataBinder.class);
    protected final ExternalResourceDAO resourceDAO;
    protected final RealmDAO realmDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final ImplementationDAO implementationDAO;
    protected final EntityFactory entityFactory;

    public PolicyDataBinderImpl(ExternalResourceDAO resourceDAO, RealmDAO realmDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, EntityFactory entityFactory) {
        this.resourceDAO = resourceDAO;
        this.realmDAO = realmDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.implementationDAO = implementationDAO;
        this.entityFactory = entityFactory;
    }

    protected <T extends Policy> T getPolicy(T policy, PolicyTO policyTO) {
        Object result = policy;
        if (policyTO instanceof PasswordPolicyTO) {
            PasswordPolicyTO passwordPolicyTO = (PasswordPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PasswordPolicy.class);
            }
            PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(result);
            passwordPolicy.setAllowNullPassword(passwordPolicyTO.isAllowNullPassword());
            passwordPolicy.setHistoryLength(passwordPolicyTO.getHistoryLength());
            passwordPolicyTO.getRules().forEach(ruleKey -> this.implementationDAO.findById(ruleKey).ifPresentOrElse(arg_0 -> ((PasswordPolicy)passwordPolicy).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), ruleKey)));
            passwordPolicy.getRules().removeIf(implementation -> !passwordPolicyTO.getRules().contains(implementation.getKey()));
        } else if (policyTO instanceof AccountPolicyTO) {
            AccountPolicyTO accountPolicyTO = (AccountPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(AccountPolicy.class);
            }
            AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(result);
            accountPolicy.setMaxAuthenticationAttempts(accountPolicyTO.getMaxAuthenticationAttempts());
            accountPolicy.setPropagateSuspension(accountPolicyTO.isPropagateSuspension());
            accountPolicyTO.getRules().forEach(ruleKey -> this.implementationDAO.findById(ruleKey).ifPresentOrElse(arg_0 -> ((AccountPolicy)accountPolicy).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), ruleKey)));
            accountPolicy.getRules().removeIf(implementation -> !accountPolicyTO.getRules().contains(implementation.getKey()));
        } else if (policyTO instanceof PropagationPolicyTO) {
            PropagationPolicyTO propagationPolicyTO = (PropagationPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PropagationPolicy.class);
            }
            PropagationPolicy propagationPolicy = (PropagationPolicy)PropagationPolicy.class.cast(result);
            propagationPolicy.setFetchAroundProvisioning(propagationPolicyTO.isFetchAroundProvisioning());
            propagationPolicy.setUpdateDelta(propagationPolicyTO.isUpdateDelta());
            propagationPolicy.setBackOffStrategy(propagationPolicyTO.getBackOffStrategy());
            propagationPolicy.setBackOffParams(propagationPolicyTO.getBackOffParams());
            propagationPolicy.setMaxAttempts(propagationPolicyTO.getMaxAttempts());
        } else if (policyTO instanceof InboundPolicyTO) {
            InboundPolicyTO inboundPolicyTO = (InboundPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(InboundPolicy.class);
            }
            InboundPolicy inboundPolicy = (InboundPolicy)InboundPolicy.class.cast(result);
            inboundPolicy.setConflictResolutionAction(inboundPolicyTO.getConflictResolutionAction());
            inboundPolicyTO.getCorrelationRules().forEach((type, impl) -> this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> {
                InboundCorrelationRuleEntity correlationRule = inboundPolicy.getCorrelationRule(anyType.getKey()).orElse(null);
                if (correlationRule == null) {
                    correlationRule = (InboundCorrelationRuleEntity)this.entityFactory.newEntity(InboundCorrelationRuleEntity.class);
                    correlationRule.setAnyType(anyType);
                    correlationRule.setInboundPolicy(inboundPolicy);
                    inboundPolicy.add(correlationRule);
                }
                Implementation rule = (Implementation)this.implementationDAO.findById(impl).orElseThrow(() -> new NotFoundException("Implementation " + type + " " + impl));
                correlationRule.setImplementation(rule);
            }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", type)));
            inboundPolicy.getCorrelationRules().removeIf(anyFilter -> !inboundPolicyTO.getCorrelationRules().containsKey(anyFilter.getAnyType().getKey()));
        } else if (policyTO instanceof PushPolicyTO) {
            PushPolicyTO pushPolicyTO = (PushPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PushPolicy.class);
            }
            PushPolicy pushPolicy = (PushPolicy)PushPolicy.class.cast(result);
            pushPolicy.setConflictResolutionAction(pushPolicyTO.getConflictResolutionAction());
            pushPolicyTO.getCorrelationRules().forEach((type, impl) -> this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> {
                PushCorrelationRuleEntity correlationRule = pushPolicy.getCorrelationRule(anyType.getKey()).orElse(null);
                if (correlationRule == null) {
                    correlationRule = (PushCorrelationRuleEntity)this.entityFactory.newEntity(PushCorrelationRuleEntity.class);
                    correlationRule.setAnyType(anyType);
                    correlationRule.setPushPolicy(pushPolicy);
                    pushPolicy.add(correlationRule);
                }
                Implementation rule = (Implementation)this.implementationDAO.findById(impl).orElseThrow(() -> new NotFoundException("Implementation " + type + " " + impl));
                correlationRule.setImplementation(rule);
            }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", type)));
            pushPolicy.getCorrelationRules().removeIf(anyFilter -> !pushPolicyTO.getCorrelationRules().containsKey(anyFilter.getAnyType().getKey()));
        } else if (policyTO instanceof AuthPolicyTO) {
            AuthPolicyTO authPolicyTO = (AuthPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(AuthPolicy.class);
            }
            AuthPolicy authPolicy = (AuthPolicy)AuthPolicy.class.cast(result);
            authPolicy.setName(authPolicyTO.getKey());
            authPolicy.setConf(authPolicyTO.getConf());
        } else if (policyTO instanceof AccessPolicyTO) {
            AccessPolicyTO accessPolicyTO = (AccessPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(AccessPolicy.class);
            }
            AccessPolicy accessPolicy = (AccessPolicy)AccessPolicy.class.cast(result);
            accessPolicy.setName(accessPolicyTO.getKey());
            accessPolicy.setConf(accessPolicyTO.getConf());
        } else if (policyTO instanceof AttrReleasePolicyTO) {
            AttrReleasePolicyTO attrReleasePolicyTO = (AttrReleasePolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(AttrReleasePolicy.class);
            }
            AttrReleasePolicy attrReleasePolicy = (AttrReleasePolicy)AttrReleasePolicy.class.cast(result);
            attrReleasePolicy.setName(attrReleasePolicyTO.getKey());
            attrReleasePolicy.setOrder(attrReleasePolicyTO.getOrder());
            attrReleasePolicy.setStatus(Boolean.valueOf(attrReleasePolicyTO.getStatus()));
            attrReleasePolicy.setConf(attrReleasePolicyTO.getConf());
        } else if (policyTO instanceof TicketExpirationPolicyTO) {
            TicketExpirationPolicyTO ticketExpirationPolicyTO = (TicketExpirationPolicyTO)policyTO;
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(TicketExpirationPolicy.class);
            }
            TicketExpirationPolicy ticketExpirationPolicy = (TicketExpirationPolicy)TicketExpirationPolicy.class.cast(result);
            ticketExpirationPolicy.setConf(ticketExpirationPolicyTO.getConf());
        }
        if (result != null) {
            result.setName(policyTO.getName());
        }
        return result;
    }

    public <T extends Policy> T create(PolicyTO policyTO) {
        return this.getPolicy(null, policyTO);
    }

    public <T extends Policy> T update(T policy, PolicyTO policyTO) {
        return this.getPolicy(policy, policyTO);
    }

    public <T extends PolicyTO> T getPolicyTO(Policy policy) {
        PasswordPolicyTO policyTO = null;
        if (policy instanceof PasswordPolicy) {
            PasswordPolicyTO passwordPolicyTO;
            PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(policy);
            policyTO = passwordPolicyTO = new PasswordPolicyTO();
            passwordPolicyTO.setAllowNullPassword(passwordPolicy.isAllowNullPassword());
            passwordPolicyTO.setHistoryLength(passwordPolicy.getHistoryLength());
            passwordPolicyTO.getRules().addAll(passwordPolicy.getRules().stream().map(Entity::getKey).toList());
        } else if (policy instanceof AccountPolicy) {
            AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(policy);
            AccountPolicyTO accountPolicyTO = new AccountPolicyTO();
            policyTO = accountPolicyTO;
            accountPolicyTO.setMaxAuthenticationAttempts(accountPolicy.getMaxAuthenticationAttempts());
            accountPolicyTO.setPropagateSuspension(accountPolicy.isPropagateSuspension());
            accountPolicyTO.getRules().addAll(accountPolicy.getRules().stream().map(Entity::getKey).toList());
            accountPolicyTO.getPassthroughResources().addAll(this.resourceDAO.findByPolicy((Policy)accountPolicy).stream().map(Entity::getKey).toList());
        } else if (policy instanceof PropagationPolicy) {
            PropagationPolicy propagationPolicy = (PropagationPolicy)PropagationPolicy.class.cast(policy);
            PropagationPolicyTO propagationPolicyTO = new PropagationPolicyTO();
            policyTO = propagationPolicyTO;
            propagationPolicyTO.setFetchAroundProvisioning(propagationPolicy.isFetchAroundProvisioning());
            propagationPolicyTO.setUpdateDelta(propagationPolicy.isUpdateDelta());
            propagationPolicyTO.setBackOffStrategy(propagationPolicy.getBackOffStrategy());
            propagationPolicyTO.setBackOffParams(propagationPolicy.getBackOffParams());
            propagationPolicyTO.setMaxAttempts(propagationPolicy.getMaxAttempts());
        } else if (policy instanceof InboundPolicy) {
            InboundPolicy inboundPolicy = (InboundPolicy)policy;
            InboundPolicyTO inboundPolicyTO = new InboundPolicyTO();
            policyTO = inboundPolicyTO;
            inboundPolicyTO.setConflictResolutionAction(inboundPolicy.getConflictResolutionAction());
            inboundPolicy.getCorrelationRules().forEach(rule -> inboundPolicyTO.getCorrelationRules().put(rule.getAnyType().getKey(), rule.getImplementation().getKey()));
        } else if (policy instanceof PushPolicy) {
            PushPolicy pushPolicy = (PushPolicy)policy;
            PushPolicyTO pushPolicyTO = new PushPolicyTO();
            policyTO = pushPolicyTO;
            pushPolicyTO.setConflictResolutionAction(pushPolicy.getConflictResolutionAction());
            pushPolicy.getCorrelationRules().forEach(rule -> pushPolicyTO.getCorrelationRules().put(rule.getAnyType().getKey(), rule.getImplementation().getKey()));
        } else if (policy instanceof AuthPolicy) {
            AuthPolicy authPolicy = (AuthPolicy)policy;
            AuthPolicyTO authPolicyTO = new AuthPolicyTO();
            policyTO = authPolicyTO;
            authPolicyTO.setConf(authPolicy.getConf());
        } else if (policy instanceof AccessPolicy) {
            AccessPolicy accessPolicy = (AccessPolicy)policy;
            AccessPolicyTO accessPolicyTO = new AccessPolicyTO();
            policyTO = accessPolicyTO;
            accessPolicyTO.setConf(accessPolicy.getConf());
        } else if (policy instanceof AttrReleasePolicy) {
            AttrReleasePolicy attrReleasePolicy = (AttrReleasePolicy)AttrReleasePolicy.class.cast(policy);
            AttrReleasePolicyTO attrReleasePolicyTO = new AttrReleasePolicyTO();
            policyTO = attrReleasePolicyTO;
            attrReleasePolicyTO.setOrder(attrReleasePolicy.getOrder());
            attrReleasePolicyTO.setStatus(Boolean.valueOf(attrReleasePolicy.getStatus()));
            attrReleasePolicyTO.setConf(attrReleasePolicy.getConf());
        } else if (policy instanceof TicketExpirationPolicy) {
            TicketExpirationPolicy ticketExpirationPolicy = (TicketExpirationPolicy)TicketExpirationPolicy.class.cast(policy);
            TicketExpirationPolicyTO ticketExpirationPolicyTO = new TicketExpirationPolicyTO();
            policyTO = ticketExpirationPolicyTO;
            ticketExpirationPolicyTO.setConf(ticketExpirationPolicy.getConf());
        }
        if (policyTO != null) {
            policyTO.setKey(policy.getKey());
            policyTO.setName(policy.getName());
            if (!(policy instanceof AuthPolicy || policy instanceof AccessPolicy || policy instanceof AttrReleasePolicy || policy instanceof TicketExpirationPolicy)) {
                policyTO.getUsedByResources().addAll(this.resourceDAO.findByPolicy(policy).stream().map(Entity::getKey).toList());
            }
            policyTO.getUsedByRealms().addAll(this.realmDAO.findByPolicy(policy).stream().map(Realm::getFullPath).toList());
        }
        return (T)policyTO;
    }
}

