/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.shaded.io.netty.channel.EventLoop;
import io.micrometer.shaded.io.netty.util.concurrent.SingleThreadEventExecutor;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.internal.util.MapUtils;
import io.micrometer.shaded.reactor.netty.transport.EventLoopMeters;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class MicrometerEventLoopMeterRegistrar {
    static final MicrometerEventLoopMeterRegistrar INSTANCE = new MicrometerEventLoopMeterRegistrar();
    private final ConcurrentMap<String, EventLoop> cache = new ConcurrentHashMap<String, EventLoop>();

    private MicrometerEventLoopMeterRegistrar() {
    }

    void registerMetrics(EventLoop eventLoop) {
        if (eventLoop instanceof SingleThreadEventExecutor) {
            SingleThreadEventExecutor singleThreadEventExecutor = (SingleThreadEventExecutor)((Object)eventLoop);
            String executorName = singleThreadEventExecutor.threadProperties().name();
            MapUtils.computeIfAbsent(this.cache, executorName, key -> {
                Gauge.builder((String)EventLoopMeters.PENDING_TASKS.getName(), singleThreadEventExecutor::pendingTasks).tag(EventLoopMeters.EventLoopMetersTags.NAME.asString(), executorName).register(Metrics.REGISTRY);
                return eventLoop;
            });
        }
    }
}

