/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.tracking;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ServiceAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;

public class DefaultDescendantTicketsTrackingPolicy
implements TicketTrackingPolicy {
    private static final char DELIMITER = ',';

    public String trackTicket(Ticket ownerTicket, Ticket ticket) {
        if (ownerTicket instanceof TicketGrantingTicket) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ownerTicket;
            Object trackedEntry = ticket.getId();
            if (ticket instanceof ServiceAwareTicket) {
                ServiceAwareTicket sat = (ServiceAwareTicket)ticket;
                trackedEntry = (String)trackedEntry + "," + sat.getService().getId();
            }
            tgt.getDescendantTickets().add(trackedEntry);
            return trackedEntry;
        }
        return super.trackTicket(ownerTicket, ticket);
    }

    public String extractTicket(String entry) {
        return StringUtils.substringBefore((String)entry, (int)44);
    }

    protected String extractService(String entry) {
        return StringUtils.substringAfter((String)entry, (int)44);
    }

    public long countTickets(Ticket ticketGrantingTicket, String ticketId) {
        if (ticketGrantingTicket instanceof TicketGrantingTicket) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticketGrantingTicket;
            return tgt.getDescendantTickets().stream().map(this::extractTicket).filter(StringUtils::isNotBlank).filter(id -> id.equals(ticketId)).count();
        }
        return super.countTickets(ticketGrantingTicket, ticketId);
    }

    public long countTicketsFor(Ticket ticketGrantingTicket, Service service) {
        if (ticketGrantingTicket instanceof TicketGrantingTicket) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticketGrantingTicket;
            return tgt.getDescendantTickets().stream().map(this::extractService).filter(StringUtils::isNotBlank).filter(id -> id.equals(service.getId())).count();
        }
        return super.countTicketsFor(ticketGrantingTicket, service);
    }
}

