/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.device.MultifactorAuthenticationDeviceManager;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.jooq.lambda.Unchecked;

public class DuoSecurityMultifactorAuthenticationDeviceManager
implements MultifactorAuthenticationDeviceManager {
    private final DuoSecurityMultifactorAuthenticationProvider duoSecurityMultifactorAuthenticationProvider;

    public List<MultifactorAuthenticationRegisteredDevice> findRegisteredDevices(Principal principal) {
        return Stream.of(this.duoSecurityMultifactorAuthenticationProvider).filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).map(provider -> provider.getDuoAuthenticationService().getAdminApiService()).filter(Optional::isPresent).map(Optional::get).map(Unchecked.function(service -> service.getDuoSecurityUserAccount(principal.getId()))).filter(Optional::isPresent).map(Optional::get).map(this::mapDuoSecurityDevice).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void removeRegisteredDevice(Principal principal, String deviceId) {
        Stream.of(this.duoSecurityMultifactorAuthenticationProvider).filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).map(provider -> provider.getDuoAuthenticationService().getAdminApiService()).filter(Optional::isPresent).map(Optional::get).forEach(Unchecked.consumer(service -> service.deleteDuoSecurityUserDevice(principal.getId(), deviceId)));
    }

    protected List<MultifactorAuthenticationRegisteredDevice> mapDuoSecurityDevice(DuoSecurityUserAccount acct) {
        return acct.getDevices().stream().map(device -> {
            String model = String.format("%s %s", StringUtils.defaultString((String)device.getModel()), StringUtils.defaultString((String)device.getPlatform())).trim();
            return MultifactorAuthenticationRegisteredDevice.builder().id(device.getId()).type(device.getType()).model(model).number(device.getNumber()).name((String)StringUtils.defaultIfBlank((CharSequence)device.getName(), (CharSequence)model)).payload(device.toJson()).lastUsedDateTime(device.getLastSeen()).source("Duo Security").details(Map.of("providerId", Objects.requireNonNull(acct.getProviderId(), "Provider ID cannot be null"))).build();
        }).collect(Collectors.toList());
    }

    @Generated
    public DuoSecurityMultifactorAuthenticationDeviceManager(DuoSecurityMultifactorAuthenticationProvider duoSecurityMultifactorAuthenticationProvider) {
        this.duoSecurityMultifactorAuthenticationProvider = duoSecurityMultifactorAuthenticationProvider;
    }
}

