/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.logout.slo.SingleLogoutContinuation;
import org.apereo.cas.support.pac4j.authentication.DelegatedAuthenticationClientLogoutRequest;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationIdentityProviderFinalizeLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationIdentityProviderFinalizeLogoutAction.class);
    private final DelegatedClientAuthenticationConfigurationContext configContext;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext webContext = new JEEContext(request, response);
        String clientName = this.configContext.getDelegatedClientNameExtractor().extract((WebContext)webContext).orElse("");
        Client client = (Client)this.configContext.getIdentityProviders().findClient(clientName).orElseThrow();
        LOGGER.debug("Received logout request from [{}]", (Object)client.getName());
        String redirectUrl = this.configContext.getCasProperties().getLogout().getRedirectParameter().stream().map(arg_0 -> ((JEEContext)webContext).getRequestParameter(arg_0)).filter(Optional::isPresent).flatMap(Optional::stream).filter(StringUtils::isNotBlank).findFirst().orElse("");
        if (StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectUrl);
            String logoutUrl = builder.build().toUriString();
            LOGGER.debug("Redirect URL after logout is: [{}]", (Object)logoutUrl);
            WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)logoutUrl);
        } else {
            DelegatedAuthenticationClientLogoutRequest logoutRequest = (DelegatedAuthenticationClientLogoutRequest)DelegationWebflowUtils.getDelegatedAuthenticationLogoutRequest((RequestContext)requestContext, DelegatedAuthenticationClientLogoutRequest.class);
            if (logoutRequest != null && StringUtils.isNotBlank((CharSequence)logoutRequest.getTarget())) {
                WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)logoutRequest.getTarget());
            }
        }
        webContext.getRequestAttribute(SingleLogoutContinuation.class.getName(), SingleLogoutContinuation.class).ifPresent(continuation -> requestContext.getConversationScope().put(SingleLogoutContinuation.class.getName(), continuation));
        WebUtils.removeCredential((RequestContext)requestContext);
        return new EventFactorySupport().event((Object)this, "logout");
    }

    @Generated
    public DelegatedAuthenticationIdentityProviderFinalizeLogoutAction(DelegatedClientAuthenticationConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

