/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.DbSqlSessionFactory;
import org.flowable.common.engine.impl.db.SchemaManagerDatabaseConfiguration;
import org.flowable.common.engine.impl.interceptor.Session;

public class DbSqlSessionSchemaManagerConfiguration
implements SchemaManagerDatabaseConfiguration,
Session {
    protected final DbSqlSession dbSqlSession;

    public DbSqlSessionSchemaManagerConfiguration(DbSqlSession dbSqlSession) {
        this.dbSqlSession = dbSqlSession;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getDatabaseType() {
        return this.dbSqlSession.getDbSqlSessionFactory().getDatabaseType();
    }

    @Override
    public String getDatabaseTablePrefix() {
        return this.dbSqlSession.getDbSqlSessionFactory().getDatabaseTablePrefix();
    }

    @Override
    public boolean isTablePrefixIsSchema() {
        return this.dbSqlSession.getDbSqlSessionFactory().isTablePrefixIsSchema();
    }

    @Override
    public String getDatabaseCatalog() {
        String catalog = this.dbSqlSession.getConnectionMetadataDefaultCatalog();
        DbSqlSessionFactory dbSqlSessionFactory = this.dbSqlSession.getDbSqlSessionFactory();
        if (dbSqlSessionFactory.getDatabaseCatalog() != null && dbSqlSessionFactory.getDatabaseCatalog().length() > 0) {
            catalog = dbSqlSessionFactory.getDatabaseCatalog();
        }
        return catalog;
    }

    @Override
    public String getDatabaseSchema() {
        String schema = this.dbSqlSession.getConnectionMetadataDefaultSchema();
        DbSqlSessionFactory dbSqlSessionFactory = this.dbSqlSession.getDbSqlSessionFactory();
        if (dbSqlSessionFactory.getDatabaseSchema() != null && dbSqlSessionFactory.getDatabaseSchema().length() > 0) {
            schema = dbSqlSessionFactory.getDatabaseSchema();
        } else if (dbSqlSessionFactory.isTablePrefixIsSchema() && StringUtils.isNotEmpty((CharSequence)dbSqlSessionFactory.getDatabaseTablePrefix()) && StringUtils.isNotEmpty((CharSequence)(schema = dbSqlSessionFactory.getDatabaseTablePrefix())) && schema.endsWith(".")) {
            schema = schema.substring(0, schema.length() - 1);
        }
        return schema;
    }

    @Override
    public Connection getConnection() {
        return this.dbSqlSession.getSqlSession().getConnection();
    }
}

