/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.collectors.AssetPathCollector;
import edu.emory.mathcs.util.classloader.jar.JarProxy;
import edu.emory.mathcs.util.classloader.jar.JarURLConnection;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class WebSphereClasspathAssetPathCollector
implements AssetPathCollector {
    @Override
    public boolean accept(URL url) {
        return true;
    }

    @Override
    public Collection<String> collect(URL url, Pattern filterExpr) {
        HashSet<String> assetPaths = new HashSet<String>();
        try {
            Set<String> paths = this.collectFromWebJarPath(url, filterExpr);
            assetPaths.addAll(paths);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return assetPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> collectFromWebJarPath(URL webJarPathResource, Pattern filterExpr) throws IOException {
        HashSet<String> assetPaths = new HashSet<String>();
        JarURLConnection urlConnection = new JarURLConnection(webJarPathResource, (JarURLConnection.JarOpener)new JarProxy());
        try (JarFile jar = null;){
            jar = urlConnection.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String innerJarEntryName = entries.nextElement().getName();
                if (this.isDirectory(innerJarEntryName) || !filterExpr.matcher(innerJarEntryName).matches()) continue;
                assetPaths.add(innerJarEntryName);
            }
        }
        return assetPaths;
    }

    private boolean isDirectory(String innerJarEntryName) {
        return innerJarEntryName.endsWith("/");
    }
}

