/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationAccessibility;
import com.okta.sdk.resource.application.ApplicationBuilder;
import com.okta.sdk.resource.application.ApplicationSignOnMode;
import com.okta.sdk.resource.application.ApplicationVisibility;
import com.okta.sdk.resource.application.ApplicationVisibilityHide;
import java.util.Objects;

public class DefaultApplicationBuilder<T extends ApplicationBuilder>
implements ApplicationBuilder<T> {
    protected String name;
    protected String label;
    protected String errorRedirectUrl;
    protected String loginRedirectUrl;
    protected Boolean selfService;
    protected ApplicationSignOnMode signOnMode;
    protected Boolean iOS;
    protected Boolean web;

    public T setName(String name) {
        this.name = name;
        return this.self();
    }

    public T setLabel(String label) {
        this.label = label;
        return this.self();
    }

    public T setErrorRedirectUrl(String errorRedirectUrl) {
        this.errorRedirectUrl = errorRedirectUrl;
        return this.self();
    }

    public T setLoginRedirectUrl(String loginRedirectUrl) {
        this.loginRedirectUrl = loginRedirectUrl;
        return this.self();
    }

    public T setSelfService(Boolean selfService) {
        this.selfService = selfService;
        return this.self();
    }

    public T setSignOnMode(ApplicationSignOnMode signOnMode) {
        if (signOnMode == ApplicationSignOnMode.SDK_UNKNOWN) {
            throw new IllegalArgumentException("The " + signOnMode.getClass().getName() + ".SDK_UNKNOWN can not be used in setter");
        }
        this.signOnMode = signOnMode;
        return this.self();
    }

    public T setIOS(Boolean iOS) {
        this.iOS = iOS;
        return this.self();
    }

    public T setWeb(Boolean web) {
        this.web = web;
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    public Application buildAndCreate(Client client) {
        return client.createApplication(this.build(client));
    }

    private Application build(Client client) {
        Application application = (Application)client.instantiate(Application.class);
        if (Strings.hasText((String)this.name)) {
            ((AbstractResource)application).setProperty("name", this.name, true);
        }
        if (Strings.hasText((String)this.label)) {
            application.setLabel(this.label);
        }
        if (Objects.nonNull(this.signOnMode)) {
            application.setSignOnMode(this.signOnMode);
        }
        application.setAccessibility((ApplicationAccessibility)client.instantiate(ApplicationAccessibility.class));
        ApplicationAccessibility applicationAccessibility = application.getAccessibility();
        if (Strings.hasText((String)this.loginRedirectUrl)) {
            applicationAccessibility.setLoginRedirectUrl(this.loginRedirectUrl);
        }
        if (Strings.hasText((String)this.errorRedirectUrl)) {
            applicationAccessibility.setErrorRedirectUrl(this.errorRedirectUrl);
        }
        if (Objects.nonNull(this.selfService)) {
            applicationAccessibility.setSelfService(this.selfService);
        }
        application.setVisibility((ApplicationVisibility)client.instantiate(ApplicationVisibility.class));
        ApplicationVisibility applicationVisibility = application.getVisibility();
        ApplicationVisibilityHide applicationVisibilityHide = (ApplicationVisibilityHide)client.instantiate(ApplicationVisibilityHide.class);
        if (Objects.nonNull(this.iOS)) {
            applicationVisibility.setHide(applicationVisibilityHide.setIOS(this.iOS));
        }
        if (Objects.nonNull(this.web)) {
            applicationVisibility.setHide(applicationVisibilityHide.setWeb(this.web));
        }
        return application;
    }
}

