/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionInformation;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcBackChannelLogoutHandler
implements LogoutHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final OidcSessionRegistry sessionRegistry;
    private RestOperations restOperations = new RestTemplate();
    private String logoutUri = "{baseUrl}/logout/connect/back-channel/{registrationId}";
    private String sessionCookieName = "JSESSIONID";
    private final OAuth2ErrorHttpMessageConverter errorHttpMessageConverter = new OAuth2ErrorHttpMessageConverter();

    public OidcBackChannelLogoutHandler(OidcSessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (!(authentication instanceof OidcBackChannelLogoutAuthentication)) {
            if (this.logger.isDebugEnabled()) {
                String message = "Did not perform OIDC Back-Channel Logout since authentication [%s] was of the wrong type";
                this.logger.debug((Object)String.format(message, authentication.getClass().getSimpleName()));
            }
            return;
        }
        OidcBackChannelLogoutAuthentication token = (OidcBackChannelLogoutAuthentication)authentication;
        Iterable sessions = this.sessionRegistry.removeSessionInformation(token.getPrincipal());
        ArrayList<String> errors = new ArrayList<String>();
        int totalCount = 0;
        int invalidatedCount = 0;
        for (OidcSessionInformation session : sessions) {
            ++totalCount;
            try {
                this.eachLogout(request, token, session);
                ++invalidatedCount;
            }
            catch (RestClientException ex) {
                this.logger.debug((Object)"Failed to invalidate session", (Throwable)ex);
                errors.add(ex.getMessage());
                this.sessionRegistry.saveSessionInformation(session);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("Invalidated %d out of %d sessions", invalidatedCount, totalCount));
        }
        if (!errors.isEmpty()) {
            this.handleLogoutFailure(response, this.oauth2Error(errors));
        }
    }

    private void eachLogout(HttpServletRequest request, OidcBackChannelLogoutAuthentication token, OidcSessionInformation session) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cookie", this.sessionCookieName + "=" + session.getSessionId());
        for (Map.Entry credential : session.getAuthorities().entrySet()) {
            headers.add((String)credential.getKey(), (String)credential.getValue());
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        String logout = this.computeLogoutEndpoint(request, token);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"logout_token", (Object)token.getPrincipal().getTokenValue());
        body.add((Object)"_spring_security_internal_logout", (Object)"true");
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        this.restOperations.postForEntity(logout, (Object)entity, Object.class, new Object[0]);
    }

    String computeLogoutEndpoint(HttpServletRequest request, OidcBackChannelLogoutAuthentication token) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        String path = uriComponents.getPath();
        uriVariables.put("basePath", path != null ? path : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        String registrationId = token.getClientRegistration().getRegistrationId();
        uriVariables.put("registrationId", registrationId);
        return UriComponentsBuilder.fromUriString((String)this.logoutUri).buildAndExpand(uriVariables).toUriString();
    }

    private OAuth2Error oauth2Error(Collection<String> errors) {
        return new OAuth2Error("partial_logout", "not all sessions were terminated: " + String.valueOf(errors), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
    }

    private void handleLogoutFailure(HttpServletResponse response, OAuth2Error error) {
        response.setStatus(400);
        try {
            this.errorHttpMessageConverter.write((Object)error, null, (HttpOutputMessage)new ServletServerHttpResponse(response));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setLogoutUri(String logoutUri) {
        Assert.hasText((String)logoutUri, (String)"logoutUri cannot be empty");
        this.logoutUri = logoutUri;
    }

    public void setSessionCookieName(String sessionCookieName) {
        Assert.hasText((String)sessionCookieName, (String)"clientSessionCookieName cannot be empty");
        this.sessionCookieName = sessionCookieName;
    }
}

