/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.util;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.filter.FilteredHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;

public final class References {
    private static final Pattern MIN_PATTERN = Pattern.compile("\\.(?=[^.]*$)");

    private References() {
        throw new UnsupportedOperationException();
    }

    public static String appendMinificationIdentifier(String referenceUrl) {
        if (!Strings.isEmpty((String)referenceUrl) && referenceUrl.contains(".") && Application.get().getResourceSettings().getUseMinifiedResources()) {
            return MIN_PATTERN.matcher(referenceUrl).replaceFirst(".min.");
        }
        return Strings2.nullToEmpty((String)referenceUrl);
    }

    public static void renderWithFilter(IHeaderResponse response, JavaScriptResourceReference ... references) {
        ArrayList<JavaScriptReferenceHeaderItem> headerItems = new ArrayList<JavaScriptReferenceHeaderItem>();
        for (JavaScriptResourceReference reference : references) {
            headerItems.add(JavaScriptHeaderItem.forReference((ResourceReference)reference));
        }
        References.renderWithFilter(response, headerItems.toArray(new JavaScriptReferenceHeaderItem[headerItems.size()]));
    }

    public static void renderWithFilter(IHeaderResponse response, JavaScriptReferenceHeaderItem ... headerItems) {
        References.renderWithFilter(Bootstrap.getSettings(), response, headerItems);
    }

    public static void renderWithFilter(IBootstrapSettings settings, IHeaderResponse response, JavaScriptReferenceHeaderItem ... headerItems) {
        String filterName = settings.getJsResourceFilterName();
        if (Strings.isEmpty((String)filterName)) {
            for (JavaScriptReferenceHeaderItem headerItem : headerItems) {
                response.render((HeaderItem)headerItem);
            }
        } else {
            for (JavaScriptReferenceHeaderItem headerItem : headerItems) {
                response.render((HeaderItem)new FilteredHeaderItem((HeaderItem)headerItem, filterName));
            }
        }
    }
}

