/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.support;

import com.google.common.base.Predicates;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.support.AbstractProtocolAttributeEncoder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.validation.ValidationResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasProtocolAttributeEncoder
extends AbstractProtocolAttributeEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasProtocolAttributeEncoder.class);
    private final CipherExecutor<String, String> cacheCredentialCipherExecutor;

    public DefaultCasProtocolAttributeEncoder(ServicesManager servicesManager, RegisteredServiceCipherExecutor cipherExecutor, CipherExecutor<String, String> cacheCredentialCipherExecutor) {
        super(servicesManager, cipherExecutor);
        this.cacheCredentialCipherExecutor = cacheCredentialCipherExecutor;
    }

    private static void sanitizeAndTransformAttributeNames(Map<String, Object> attributes, Service webApplicationService) {
        WebApplicationService was;
        if (webApplicationService instanceof WebApplicationService && (was = (WebApplicationService)webApplicationService).getFormat() == ValidationResponseType.JSON) {
            LOGGER.trace("Skipping attribute name sanitization for [{}]", (Object)webApplicationService);
            return;
        }
        LOGGER.trace("Sanitizing attribute names in preparation of the final validation response");
        Set<Pair> encodedAttributes = attributes.keySet().stream().filter(DefaultCasProtocolAttributeEncoder::getSanitizingAttributeNamePredicate).map(attribute -> {
            Object values = attributes.get(attribute);
            LOGGER.trace("Encoding attribute [{}] with value(s) [{}]", attribute, values);
            return Pair.of((Object)ProtocolAttributeEncoder.encodeAttribute((String)attribute), values);
        }).collect(Collectors.toSet());
        if (!encodedAttributes.isEmpty()) {
            LOGGER.info("Found [{}] attribute(s) that need to be sanitized/encoded.", (Object)encodedAttributes.size());
            attributes.keySet().removeIf(DefaultCasProtocolAttributeEncoder::getSanitizingAttributeNamePredicate);
            encodedAttributes.forEach(attribute -> {
                String key = (String)attribute.getKey();
                LOGGER.trace("Sanitized attribute name to be [{}]", (Object)key);
                attributes.put(key, DefaultCasProtocolAttributeEncoder.transformAttributeValueIfNecessary(attribute.getValue()));
            });
        }
    }

    private static boolean getSanitizingAttributeNamePredicate(String s) {
        return s.contains(":") || s.contains("@");
    }

    private static void sanitizeAndTransformAttributeValues(Map<String, Object> attributes) {
        LOGGER.trace("Sanitizing attribute values in preparation of the final validation response");
        attributes.forEach((key, value) -> {
            Set values = CollectionUtils.toCollection((Object)value);
            values.stream().filter(v -> DefaultCasProtocolAttributeEncoder.getBinaryAttributeValuePredicate().test(v)).forEach(v -> attributes.put((String)key, DefaultCasProtocolAttributeEncoder.transformAttributeValueIfNecessary(v)));
        });
    }

    private static Object transformAttributeValueIfNecessary(Object attributeValue) {
        if (DefaultCasProtocolAttributeEncoder.getBinaryAttributeValuePredicate().test(attributeValue)) {
            return EncodingUtils.encodeBase64((byte[])((byte[])attributeValue));
        }
        return attributeValue;
    }

    private static Predicate<Object> getBinaryAttributeValuePredicate() {
        return Predicates.instanceOf(byte[].class);
    }

    protected void encodeAndEncryptCredentialPassword(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        if (cachedAttributesToEncode.containsKey("credential")) {
            String value = cachedAttributesToEncode.get("credential");
            String decodedValue = (String)this.cacheCredentialCipherExecutor.decode((Object)value, ArrayUtils.EMPTY_OBJECT_ARRAY);
            cachedAttributesToEncode.remove("credential");
            if (StringUtils.isNotBlank((CharSequence)decodedValue)) {
                cachedAttributesToEncode.put("credential", decodedValue);
            }
        }
        this.encryptAndEncodeAndPutIntoAttributesMap(attributes, cachedAttributesToEncode, "credential", cipher, registeredService);
    }

    protected void encodeAndEncryptProxyGrantingTicket(Map<String, Object> model, Map<String, Object> resultingAttributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        if (model.containsKey("proxyGrantingTicket")) {
            Ticket proxyGrantingTicket = (Ticket)model.get("proxyGrantingTicket");
            if (proxyGrantingTicket != null && proxyGrantingTicket.isStateless()) {
                this.putIntoAttributesMap(resultingAttributes, cachedAttributesToEncode, "proxyGrantingTicket");
            } else {
                this.encryptAndEncodeAndPutIntoAttributesMap(resultingAttributes, cachedAttributesToEncode, "proxyGrantingTicket", cipher, registeredService);
            }
        }
        this.encryptAndEncodeAndPutIntoAttributesMap(resultingAttributes, cachedAttributesToEncode, "pgtIou", cipher, registeredService);
    }

    protected void putIntoAttributesMap(Map<String, Object> resultingAttributes, Map<String, String> cachedAttributesToEncode, String cachedAttributeName) {
        String cachedAttributeValue = cachedAttributesToEncode.remove(cachedAttributeName);
        if (StringUtils.isNotBlank((CharSequence)cachedAttributeValue)) {
            resultingAttributes.put(cachedAttributeName, cachedAttributeValue);
        }
    }

    protected void encryptAndEncodeAndPutIntoAttributesMap(Map<String, Object> resultingAttributes, Map<String, String> cachedAttributesToEncode, String cachedAttributeName, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        String encodedValue;
        String cachedAttributeValue = cachedAttributesToEncode.remove(cachedAttributeName);
        String string = encodedValue = StringUtils.isNotBlank((CharSequence)cachedAttributeValue) ? cipher.encode(cachedAttributeValue, Optional.of(registeredService)) : cachedAttributeValue;
        if (StringUtils.isNotBlank((CharSequence)encodedValue)) {
            resultingAttributes.put(cachedAttributeName, encodedValue);
        }
    }

    @Override
    protected void encodeAttributesInternal(Map<String, Object> model, Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService, Service webApplicationService) {
        this.encodeAndEncryptCredentialPassword(attributes, cachedAttributesToEncode, cipher, registeredService);
        this.encodeAndEncryptProxyGrantingTicket(model, attributes, cachedAttributesToEncode, cipher, registeredService);
        DefaultCasProtocolAttributeEncoder.sanitizeAndTransformAttributeNames(attributes, webApplicationService);
        DefaultCasProtocolAttributeEncoder.sanitizeAndTransformAttributeValues(attributes);
    }
}

