/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.unique;

import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.AbstractAttributeIndex;
import com.googlecode.cqengine.index.support.Factory;
import com.googlecode.cqengine.index.support.IndexSupport;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.iterator.UnmodifiableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UniqueIndex<A, O>
extends AbstractAttributeIndex<A, O>
implements OnHeapTypeIndex {
    protected static final int INDEX_RETRIEVAL_COST = 25;
    protected final Factory<ConcurrentMap<A, O>> indexMapFactory;
    protected final ConcurrentMap<A, O> indexMap;

    protected UniqueIndex(Factory<ConcurrentMap<A, O>> indexMapFactory, Attribute<O, A> attribute) {
        super(attribute, (Set<Class<? extends Query>>)new HashSet<Class<? extends Query>>(){
            {
                this.add(Equal.class);
                this.add(In.class);
            }
        });
        this.indexMapFactory = indexMapFactory;
        this.indexMap = indexMapFactory.create();
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        Class<?> queryClass = query.getClass();
        return queryClass.equals(Equal.class) || queryClass.equals(In.class);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isQuantized() {
        return false;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        Class<?> queryClass = query.getClass();
        if (queryClass.equals(Equal.class)) {
            ConcurrentMap<A, O> indexMap = this.indexMap;
            Equal equal = (Equal)query;
            return this.retrieveEqual(equal, queryOptions, indexMap);
        }
        if (queryClass.equals(In.class)) {
            In in = (In)query;
            return this.retrieveIn(in, queryOptions, this.indexMap);
        }
        throw new IllegalArgumentException("Unsupported query: " + query);
    }

    protected ResultSet<O> retrieveIn(final In<O, A> in, final QueryOptions queryOptions, final ConcurrentMap<A, O> indexMap) {
        Iterable results = new Iterable<ResultSet<O>>(){

            @Override
            public Iterator<ResultSet<O>> iterator() {
                return new LazyIterator<ResultSet<O>>(){
                    final Iterator<A> values;
                    {
                        this.values = in.getValues().iterator();
                    }

                    protected ResultSet<O> computeNext() {
                        if (this.values.hasNext()) {
                            return UniqueIndex.this.retrieveEqual(new Equal(in.getAttribute(), this.values.next()), queryOptions, indexMap);
                        }
                        return (ResultSet)this.endOfData();
                    }
                };
            }
        };
        return IndexSupport.deduplicateIfNecessary(results, in, this.getAttribute(), queryOptions, 25);
    }

    protected ResultSet<O> retrieveEqual(final Equal<O, A> equal, final QueryOptions queryOptions, ConcurrentMap<A, O> indexMap) {
        final Object obj = indexMap.get(equal.getValue());
        return new ResultSet<O>(){

            @Override
            public Iterator<O> iterator() {
                return new UnmodifiableIterator<O>(){
                    boolean hasNext;
                    {
                        this.hasNext = obj != null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public O next() {
                        this.hasNext = false;
                        return obj;
                    }
                };
            }

            @Override
            public boolean contains(O object) {
                return object != null && obj != null && object.equals(obj);
            }

            @Override
            public boolean matches(O object) {
                return equal.matches(object, queryOptions);
            }

            @Override
            public int size() {
                return obj == null ? 0 : 1;
            }

            @Override
            public int getRetrievalCost() {
                return 25;
            }

            @Override
            public int getMergeCost() {
                return obj == null ? 0 : 1;
            }

            @Override
            public void close() {
            }

            @Override
            public Query<O> getQuery() {
                return equal;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            ConcurrentMap<A, O> indexMap = this.indexMap;
            for (Object object : objectSet) {
                Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
                for (Object attributeValue : attributeValues) {
                    Object existingValue = indexMap.put(attributeValue, object);
                    if (existingValue != null && !existingValue.equals(object)) {
                        throw new UniqueConstraintViolatedException("The application has attempted to add a duplicate object to the UniqueIndex on attribute '" + this.attribute.getAttributeName() + "', potentially causing inconsistencies between indexes. UniqueIndex should not be used with attributes which do not uniquely identify objects. Problematic attribute value: '" + attributeValue + "', problematic duplicate object: " + object);
                    }
                    modified = true;
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            ConcurrentMap<A, O> indexMap = this.indexMap;
            for (Object object : objectSet) {
                Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
                for (Object attributeValue : attributeValues) {
                    modified |= indexMap.remove(attributeValue) != null;
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.addAll(ObjectSet.fromObjectStore(objectStore, queryOptions), queryOptions);
    }

    @Override
    public void destroy(QueryOptions queryOptions) {
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.indexMap.clear();
    }

    public static <A, O> UniqueIndex<A, O> onAttribute(Attribute<O, A> attribute) {
        return UniqueIndex.onAttribute(new DefaultIndexMapFactory(), attribute);
    }

    public static <A, O> UniqueIndex<A, O> onAttribute(Factory<ConcurrentMap<A, O>> indexMapFactory, Attribute<O, A> attribute) {
        return new UniqueIndex<A, O>(indexMapFactory, attribute);
    }

    public static class DefaultIndexMapFactory<A, O>
    implements Factory<ConcurrentMap<A, O>> {
        @Override
        public ConcurrentMap<A, O> create() {
            return new ConcurrentHashMap();
        }
    }

    public static class UniqueConstraintViolatedException
    extends RuntimeException {
        public UniqueConstraintViolatedException(String message) {
            super(message);
        }
    }
}

