/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.LogCleaner;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.utils.Implicits;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t5e!B\u001a5\u0003\u0003I\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0001F\u0011%I\u0005\u00011AA\u0002\u0013\u0005!\nC\u0005Q\u0001\u0001\u0007\t\u0011)Q\u0005\r\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB.\u0001A\u0003%1\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\r%\u0004\u0001\u0015!\u0003_\u0011\u001dQ\u0007A1A\u0005\n-Daa\u001c\u0001!\u0002\u0013a\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u0002:\t\u000fY\u0004!\u0019!C\u0005o\"11\u0010\u0001Q\u0001\naDq\u0001 \u0001C\u0002\u0013%1\u000e\u0003\u0004~\u0001\u0001\u0006I\u0001\u001c\u0005\b}\u0002\u0011\r\u0011\"\u0003l\u0011\u0019y\b\u0001)A\u0005Y\"A\u0011\u0011\u0001\u0001C\u0002\u0013%q\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002=\t\u000f\u0005\u0015\u0001A\"\u0001\u0002\b!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\n\u0003O\u0002\u0011\u0013!C\u0001\u0003SB\u0011\"a \u0001#\u0003%\t!!!\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0005\"CAF\u0001E\u0005I\u0011AAG\u0011%\t\t\nAI\u0001\n\u0003\ti\tC\u0005\u0002\u0014\u0002\t\n\u0011\"\u0001\u0002\b\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005\"CAq\u0001E\u0005I\u0011AAA\u0011%\t\u0019\u000fAI\u0001\n\u0003\ti\tC\u0005\u0002f\u0002\t\n\u0011\"\u0001\u0002\b\"I\u0011q\u001d\u0001\u0012\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003S\u0004\u0011\u0013!C\u0001\u0003\u000fC\u0011\"a;\u0001#\u0003%\t!!$\t\u0013\u00055\b!%A\u0005\u0002\u00055\u0005\"CAx\u0001E\u0005I\u0011AAD\u0011%\t\t\u0010AI\u0001\n\u0003\t\u0019\u0010C\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002j!A\u0011\u0011 \u0001A\u0002\u0013%1\u000eC\u0005\u0002|\u0002\u0001\r\u0011\"\u0003\u0002~\"9!\u0011\u0001\u0001!B\u0013a\u0007B\u0002B\u0002\u0001\u0011\u00051\u000eC\u0004\u0003\u0006\u0001!\t!!\n\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!I!\u0011\u000b\u0001\u0012\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0005'\u0002\u0011\u0013!C\u0001\u0005+BqA!\u0017\u0001\t\u0003\u0011Y\u0006C\u0004\u0003z\u0001!\tAa\u001f\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005U2\u0014a\u00017pO*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0004CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0005B\u00111\tA\u0007\u0002i\u000591\r\\3b]\u0016\u0014X#\u0001$\u0011\u0005\r;\u0015B\u0001%5\u0005)aunZ\"mK\u0006tWM]\u0001\fG2,\u0017M\\3s?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u00111\bT\u0005\u0003\u001br\u0012A!\u00168ji\"9qjAA\u0001\u0002\u00041\u0015a\u0001=%c\u0005A1\r\\3b]\u0016\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002'B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0003S>T\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[+\n!a)\u001b7f\u0003\u001dawn\u001a#je\u0002\nA\u0001\\8hgV\ta\fE\u0002`I\u001al\u0011\u0001\u0019\u0006\u0003C\n\fq!\\;uC\ndWM\u0003\u0002dy\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0004'A\u0003'jgR\u0014UO\u001a4feB\u00111iZ\u0005\u0003QR\u0012!\"\u00168jM&,G\rT8h\u0003\u0015awnZ:!\u0003U!WMZ1vYRl\u0015\r_'fgN\fw-Z*ju\u0016,\u0012\u0001\u001c\t\u0003w5L!A\u001c\u001f\u0003\u0007%sG/\u0001\feK\u001a\fW\u000f\u001c;NCblUm]:bO\u0016\u001c\u0016N_3!\u0003u!WMZ1vYRl\u0015N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|W#\u0001:\u0011\u0005m\u001a\u0018B\u0001;=\u0005\u00151En\\1u\u0003y!WMZ1vYRl\u0015N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|\u0007%A\reK\u001a\fW\u000f\u001c;NS:\u001cu.\u001c9bGRLwN\u001c'bO6\u001bV#\u0001=\u0011\u0005mJ\u0018B\u0001>=\u0005\u0011auN\\4\u00025\u0011,g-Y;mi6KgnQ8na\u0006\u001cG/[8o\u0019\u0006<Wj\u0015\u0011\u0002%\u0011,g-Y;mi\u0012+G.\u001a;f\t\u0016d\u0017-_\u0001\u0014I\u00164\u0017-\u001e7u\t\u0016dW\r^3EK2\f\u0017\u0010I\u0001\u0013I\u00164\u0017-\u001e7u'\u0016<W.\u001a8u'&TX-A\neK\u001a\fW\u000f\u001c;TK\u001elWM\u001c;TSj,\u0007%A\reK\u001a\fW\u000f\u001c;NCb\u001cu.\u001c9bGRLwN\u001c'bO6\u001b\u0018A\u00073fM\u0006,H\u000e^'bq\u000e{W\u000e]1di&|g\u000eT1h\u001bN\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0003\u0011\t\u0005-\u0011qD\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005!Q\u000f^5m\u0015\u0011\t\u0019\"!\u0006\u0002\rM,'O^3s\u0015\r9\u0014q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003;\t1a\u001c:h\u0013\u0011\t\t#!\u0004\u0003\u00115{7m\u001b+j[\u0016\f\u0001\u0002^3be\u0012|wO\u001c\u000b\u0002\u0017\"\u001aa#!\u000b\u0011\t\u0005-\u0012\u0011H\u0007\u0003\u0003[QA!a\f\u00022\u0005\u0019\u0011\r]5\u000b\t\u0005M\u0012QG\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t9$a\u0007\u0002\u000b),h.\u001b;\n\t\u0005m\u0012Q\u0006\u0002\n\u0003\u001a$XM]#bG\"\f1\u0003\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$\u0002#!\u0011\u0002L\u0005=\u00131KA,\u00037\ny&a\u0019\u0011\t\u0005\r\u0013qI\u0007\u0003\u0003\u000bR1!a\u0004X\u0013\u0011\tI%!\u0012\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0005\u0002N]\u0001\n\u00111\u0001\u0002B\u0005\t\u0002O]8qKJ$\u0018p\u0014<feJLG-Z:\t\r\u0005Es\u00031\u0001m\u00039i\u0017\r_'fgN\fw-Z*ju\u0016D\u0001\"!\u0016\u0018!\u0003\u0005\rA]\u0001\u0017[&t7\t\\3b]\u0006\u0014G.\u001a#jeRL(+\u0019;j_\"A\u0011\u0011L\f\u0011\u0002\u0003\u0007\u00010\u0001\nnS:\u001cu.\u001c9bGRLwN\u001c'bO6\u001b\b\u0002CA//A\u0005\t\u0019\u00017\u0002\u0017\u0011,G.\u001a;f\t\u0016d\u0017-\u001f\u0005\t\u0003C:\u0002\u0013!a\u0001Y\u0006Y1/Z4nK:$8+\u001b>f\u0011!\t)g\u0006I\u0001\u0002\u0004A\u0018AE7bq\u000e{W\u000e]1di&|g\u000eT1h\u001bN\fQ\u0004\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$C-\u001a4bk2$H%M\u000b\u0003\u0003WRC!!\u0011\u0002n-\u0012\u0011q\u000e\t\u0005\u0003c\nY(\u0004\u0002\u0002t)!\u0011QOA<\u0003%)hn\u00195fG.,GMC\u0002\u0002zq\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti(a\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fm_\u001e\u001cuN\u001c4jOB\u0013x\u000e]3si&,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019IK\u0002s\u0003[\nQ\u0004\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0013S3\u0001_A7\u0003uawnZ\"p]\u001aLw\r\u0015:pa\u0016\u0014H/[3tI\u0011,g-Y;mi\u0012*TCAAHU\ra\u0017QN\u0001\u001eY><7i\u001c8gS\u001e\u0004&o\u001c9feRLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005iBn\\4D_:4\u0017n\u001a)s_B,'\u000f^5fg\u0012\"WMZ1vYR$s'A\u0006nC.,7\t\\3b]\u0016\u0014Hc\u0006$\u0002\u001a\u0006\u0005\u00171YAd\u0003\u0017\fi-a4\u0002R\u0006M\u0017Q[Ap\u0011\u001d\tYJ\ba\u0001\u0003;\u000b!\u0002]1si&$\u0018n\u001c8t!\u0019\ty*a,\u00026:!\u0011\u0011UAV\u001d\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATq\u00051AH]8pizJ\u0011!P\u0005\u0004\u0003[c\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003c\u000b\u0019L\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\ti\u000b\u0010\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*!\u00111XA\u000b\u0003\u0019\u0019w.\\7p]&!\u0011qXA]\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"!\u0016\u001f!\u0003\u0005\rA\u001d\u0005\t\u0003\u000bt\u0002\u0013!a\u0001Y\u0006Qa.^7UQJ,\u0017\rZ:\t\u0011\u0005%g\u0004%AA\u0002a\f\u0011BY1dW>4g-T:\t\u0011\u0005Ec\u0004%AA\u00021D\u0001\"!\u0017\u001f!\u0003\u0005\r\u0001\u001f\u0005\t\u0003;r\u0002\u0013!a\u0001Y\"A\u0011\u0011\r\u0010\u0011\u0002\u0003\u0007A\u000e\u0003\u0005\u0002fy\u0001\n\u00111\u0001y\u0011%\t9N\bI\u0001\u0002\u0004\tI.A\ndY\u0016\fg.\u001a:J_\n+hMZ3s'&TX\r\u0005\u0003<\u00037d\u0017bAAoy\t1q\n\u001d;j_:D\u0011\"!\u0014\u001f!\u0003\u0005\r!!\u0011\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\u001a\u0014!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H\u0005N\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIY\nQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$s'A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%s\u00051R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0002v*\"\u0011\u0011\\A7\u0003Yi\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIE\n\u0014aA2ue\u000691\r\u001e:`I\u0015\fHcA&\u0002\u0000\"9qJKA\u0001\u0002\u0004a\u0017\u0001B2ue\u0002\nqaY8v]R,'/\u0001\u0006j]\u000e\u001cu.\u001e8uKJ\f\u0011b\u001e:ji\u0016$U\u000f]:\u0015\u001d\t-!\u0011\u0006B\u0017\u0005c\u0011\u0019Da\u0011\u0003HA1!Q\u0002B\b\u0005'i\u0011AY\u0005\u0004\u0005#\u0011'aA*fcB91H!\u0006m\u00053A\u0018b\u0001B\fy\t1A+\u001e9mKN\u0002BAa\u0007\u0003$9!!Q\u0004B\u0010!\r\t\u0019\u000bP\u0005\u0004\u0005Ca\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003&\t\u001d\"AB*ue&twMC\u0002\u0003\"qBaAa\u000b/\u0001\u0004a\u0017a\u00028v[.+\u0017p\u001d\u0005\u0007\u0005_q\u0003\u0019\u00017\u0002\u000f9,X\u000eR;qg\")QG\fa\u0001M\"9!Q\u0007\u0018A\u0002\t]\u0012!B2pI\u0016\u001c\u0007\u0003\u0002B\u001d\u0005\u007fi!Aa\u000f\u000b\t\tu\u0012\u0011X\u0001\tG>l\u0007O]3tg&!!\u0011\tB\u001e\u0005-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\t\u0011\t\u0015c\u0006%AA\u00021\f\u0001b\u001d;beR\\U-\u001f\u0005\n\u0005\u0013r\u0003\u0013!a\u0001\u0005\u0017\n!\"\\1hS\u000e4\u0016\r\\;f!\rY$QJ\u0005\u0004\u0005\u001fb$\u0001\u0002\"zi\u0016\f1c\u001e:ji\u0016$U\u000f]:%I\u00164\u0017-\u001e7uIU\n1c\u001e:ji\u0016$U\u000f]:%I\u00164\u0017-\u001e7uIY*\"Aa\u0016+\t\t-\u0013QN\u0001\u001cGJ,\u0017\r^3MCJ<WmU5oO2,W*Z:tC\u001e,7+\u001a;\u0015\u0011\tu#q\u000eB:\u0005o\u0002ra\u000fB0\u00053\u0011\u0019'C\u0002\u0003bq\u0012a\u0001V;qY\u0016\u0014\u0004\u0003\u0002B3\u0005Wj!Aa\u001a\u000b\t\t%\u0014\u0011X\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t5$q\r\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\r\tE\u0014\u00071\u0001m\u0003\rYW-\u001f\u0005\b\u0005k\n\u0004\u0019\u0001B&\u0003QiWm]:bO\u00164uN]7biZ+'o]5p]\"9!QG\u0019A\u0002\t]\u0012\u0001C2m_N,Gj\\4\u0015\u0007-\u0013i\bC\u00036e\u0001\u0007a\rK\u0004\u0001\u0005\u0003\u00139I!#\u0011\t\u0005-\"1Q\u0005\u0005\u0005\u000b\u000biCA\u0002UC\u001e\fQA^1mk\u0016\f#Aa#\u0002\u0017%tG/Z4sCRLwN\u001c")
public abstract class AbstractLogCleanerIntegrationTest {
    private LogCleaner cleaner;
    private final File logDir = TestUtils.tempDirectory(null, null);
    private final ListBuffer<UnifiedLog> logs = ListBuffer$.MODULE$.empty();
    private final int defaultMaxMessageSize;
    private final float defaultMinCleanableDirtyRatio;
    private final long defaultMinCompactionLagMS;
    private final int defaultDeleteDelay;
    private final int defaultSegmentSize;
    private final long defaultMaxCompactionLagMs = Long.MAX_VALUE;
    private int ctr = 0;

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    private ListBuffer<UnifiedLog> logs() {
        return this.logs;
    }

    private int defaultMaxMessageSize() {
        return this.defaultMaxMessageSize;
    }

    private float defaultMinCleanableDirtyRatio() {
        return this.defaultMinCleanableDirtyRatio;
    }

    private long defaultMinCompactionLagMS() {
        return this.defaultMinCompactionLagMS;
    }

    private int defaultDeleteDelay() {
        return this.defaultDeleteDelay;
    }

    private int defaultSegmentSize() {
        return this.defaultSegmentSize;
    }

    private long defaultMaxCompactionLagMs() {
        return this.defaultMaxCompactionLagMs;
    }

    public abstract MockTime time();

    @AfterEach
    public void teardown() {
        if (this.cleaner() != null) {
            this.cleaner().shutdown();
        }
        this.time().scheduler.shutdown();
        this.logs().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    public Properties logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs) {
        Properties props = new Properties();
        props.put("max.message.bytes", Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        props.put("segment.index.bytes", Predef$.MODULE$.int2Integer(102400));
        props.put("file.delete.delay.ms", Predef$.MODULE$.int2Integer(deleteDelay));
        props.put("cleanup.policy", "compact");
        props.put("min.cleanable.dirty.ratio", Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.put("min.compaction.lag.ms", Predef$.MODULE$.long2Long(minCompactionLagMs));
        props.put("max.compaction.lag.ms", Predef$.MODULE$.long2Long(maxCompactionLagMs));
        new Implicits.PropertiesOps(props).$plus$plus$eq(propertyOverrides);
        return props;
    }

    public Properties logConfigProperties$default$1() {
        return new Properties();
    }

    public float logConfigProperties$default$3() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public long logConfigProperties$default$4() {
        return this.defaultMinCompactionLagMS();
    }

    public int logConfigProperties$default$5() {
        return this.defaultDeleteDelay();
    }

    public int logConfigProperties$default$6() {
        return this.defaultSegmentSize();
    }

    public long logConfigProperties$default$7() {
        return this.defaultMaxCompactionLagMs();
    }

    public LogCleaner makeCleaner(Iterable<TopicPartition> partitions, float minCleanableDirtyRatio, int numThreads, long backoffMs, int maxMessageSize, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs, Option<Object> cleanerIoBufferSize, Properties propertyOverrides) {
        Pool logMap = new Pool((Option)None$.MODULE$);
        partitions.foreach((Function1 & Serializable)partition -> {
            File dir = new File(this.logDir(), new StringBuilder(1).append(partition.topic()).append("-").append(partition.partition()).toString());
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            LogConfig logConfig = new LogConfig((Map)this.logConfigProperties(propertyOverrides, maxMessageSize, minCleanableDirtyRatio, minCompactionLagMs, deleteDelay, segmentSize, maxCompactionLagMs));
            MockScheduler x$5 = $this.time().scheduler;
            MockTime x$6 = this.time();
            BrokerTopicStats x$7 = new BrokerTopicStats(false);
            ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(86400000, false);
            LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
            None$ x$12 = None$.MODULE$;
            boolean x$14 = true;
            ConcurrentHashMap x$15 = new ConcurrentHashMap();
            boolean x$16 = false;
            LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            UnifiedLog log = UnifiedLog$.MODULE$.apply(dir, logConfig, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, 600000, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17);
            logMap.put(partition, (Object)log);
            return (ListBuffer)this.logs().$plus$eq((Object)log);
        });
        CleanerConfig cleanerConfig = new CleanerConfig(numThreads, 0x400000L, 0.9, BoxesRunTime.unboxToInt((Object)cleanerIoBufferSize.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> maxMessageSize / 2)), maxMessageSize, Double.MAX_VALUE, backoffMs, true);
        return new LogCleaner(cleanerConfig, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logMap, new LogDirFailureChannel(1), (Time)this.time());
    }

    public float makeCleaner$default$2() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public long makeCleaner$default$4() {
        return 15000L;
    }

    public int makeCleaner$default$5() {
        return this.defaultMaxMessageSize();
    }

    public long makeCleaner$default$6() {
        return this.defaultMinCompactionLagMS();
    }

    public int makeCleaner$default$7() {
        return this.defaultDeleteDelay();
    }

    public int makeCleaner$default$8() {
        return this.defaultSegmentSize();
    }

    public long makeCleaner$default$9() {
        return this.defaultMaxCompactionLagMs();
    }

    public Option<Object> makeCleaner$default$10() {
        return None$.MODULE$;
    }

    public Properties makeCleaner$default$11() {
        return new Properties();
    }

    private int ctr() {
        return this.ctr;
    }

    private void ctr_$eq(int x$1) {
        this.ctr = x$1;
    }

    public int counter() {
        return this.ctr();
    }

    public void incCounter() {
        this.ctr_$eq(this.ctr() + 1);
    }

    public Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, UnifiedLog log, Compression codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$3 -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$1(this, startKey, numKeys, log, codec, magicValue, BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public int writeDups$default$5() {
        return 0;
    }

    public byte writeDups$default$6() {
        return 2;
    }

    public Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion, Compression codec) {
        String value = AbstractLogCleanerIntegrationTest.messageValue$1(128);
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec, x$5, messageFormatVersion);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    public void closeLog(UnifiedLog log) {
        log.close();
        this.logs().$minus$eq((Object)log);
    }

    public static final /* synthetic */ Tuple3 $anonfun$writeDups$2(AbstractLogCleanerIntegrationTest $this, UnifiedLog log$1, Compression codec$1, byte magicValue$1, int key) {
        String value = Integer.toString($this.counter());
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        LogAppendInfo appendInfo = log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, x$5, magicValue$1), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        log$1.updateHighWatermark(log$1.logEndOffset());
        $this.incCounter();
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)appendInfo.firstOffset()));
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeDups$1(AbstractLogCleanerIntegrationTest $this, int startKey$1, int numKeys$1, UnifiedLog log$1, Compression codec$1, byte magicValue$1, int x$3) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, magicValue$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    private static final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray((ClassTag)ClassTag$.MODULE$.Char()));
    }

    public AbstractLogCleanerIntegrationTest() {
        this.defaultMaxMessageSize = 128;
        this.defaultMinCleanableDirtyRatio = 0.0f;
        this.defaultMinCompactionLagMS = 0L;
        this.defaultDeleteDelay = 1000;
        this.defaultSegmentSize = 2048;
    }
}

