/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.template;

import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;
import org.wicketstuff.jquery.core.template.IJQueryTemplate;
import org.wicketstuff.jquery.core.template.JQueryAbstractTemplateBehavior;
import org.wicketstuff.jquery.core.template.JQueryTemplateResourceStream;

public class JQueryTemplateBehavior
extends JQueryAbstractTemplateBehavior {
    private static final long serialVersionUID = 1L;
    public static final PackageResourceReference TMPL_JS = new JQueryPluginResourceReference(JQueryTemplateBehavior.class, "jquery.tmpl.min.js");
    private String token = null;
    private final IJQueryTemplate template;

    public JQueryTemplateBehavior(IJQueryTemplate template) {
        this.template = template;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)TMPL_JS)));
    }

    public void bind(Component component) {
        super.bind(component);
        this.token = String.format("%s-template", component.getMarkupId());
    }

    public String getToken() {
        return this.token;
    }

    protected JQueryTemplateResourceStream newResourceStream() {
        return new JQueryTemplateResourceStream(this.template.getText(), this.getToken());
    }
}

