/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.pushpull;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningActions;

public class ProvisioningProfile<T extends ProvisioningTask<?>, A extends ProvisioningActions> {
    private final Connector connector;
    private final TaskType taskType;
    private final T task;
    private final ConflictResolutionAction conflictResolutionAction;
    private final String executor;
    private final boolean dryRun;
    private final List<A> actions;
    private final List<ProvisioningReport> results = new CopyOnWriteArrayList<ProvisioningReport>();

    public ProvisioningProfile(Connector connector, TaskType taskType, T task, ConflictResolutionAction conflictResolutionAction, List<A> actions, String executor, boolean dryRun) {
        this.connector = connector;
        this.taskType = taskType;
        this.task = task;
        this.conflictResolutionAction = conflictResolutionAction;
        this.actions = actions;
        this.executor = executor;
        this.dryRun = dryRun;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public T getTask() {
        return this.task;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public ConflictResolutionAction getConflictResolutionAction() {
        return this.conflictResolutionAction;
    }

    public String getExecutor() {
        return this.executor;
    }

    public List<A> getActions() {
        return this.actions;
    }

    public List<ProvisioningReport> getResults() {
        return this.results;
    }

    public String getContext() {
        return String.valueOf(this.taskType) + " Task " + this.task.getKey() + " '" + this.task.getName() + "'";
    }
}

