/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.integration.handler.advice.AbstractRequestHandlerAdvice;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ContextHolderRequestHandlerAdvice
extends AbstractRequestHandlerAdvice {
    public final Function<Message<?>, Object> valueProvider;
    public final Consumer<Object> contextSetHook;
    public final Runnable contextClearHook;

    public ContextHolderRequestHandlerAdvice(Function<Message<?>, Object> valueProvider, Consumer<Object> contextSetHook, Runnable contextClearHook) {
        Assert.notNull(valueProvider, (String)"'valueProvider' must not be null");
        Assert.notNull(contextSetHook, (String)"'contextSetHook' must not be null");
        Assert.notNull((Object)contextClearHook, (String)"'contextClearHook' must not be null");
        this.valueProvider = valueProvider;
        this.contextSetHook = contextSetHook;
        this.contextClearHook = contextClearHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doInvoke(AbstractRequestHandlerAdvice.ExecutionCallback callback, Object target, Message<?> message) {
        Object value = this.valueProvider.apply(message);
        this.logger.trace(() -> "Setting context value to: " + String.valueOf(value) + " from message: " + String.valueOf(message));
        try {
            this.contextSetHook.accept(value);
            Object object = callback.execute();
            return object;
        }
        finally {
            this.contextClearHook.run();
        }
    }
}

