/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.integration.aggregator.BarrierMessageHandler;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.HeaderAttributeCorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import reactor.util.function.Tuple2;

public class BarrierSpec
extends ConsumerEndpointSpec<BarrierSpec, BarrierMessageHandler> {
    private final long timeout;
    private MessageGroupProcessor outputProcessor = new DefaultAggregatingMessageGroupProcessor();
    private CorrelationStrategy correlationStrategy = new HeaderAttributeCorrelationStrategy("correlationId");
    @Nullable
    private MessageChannel discardChannel;
    @Nullable
    private String discardChannelName;
    @Nullable
    private Long triggerTimeout;

    protected BarrierSpec(long timeout) {
        super(null);
        this.timeout = timeout;
    }

    public BarrierSpec outputProcessor(MessageGroupProcessor outputProcessor) {
        Assert.notNull((Object)outputProcessor, (String)"'outputProcessor' must not be null.");
        this.outputProcessor = outputProcessor;
        return this;
    }

    public BarrierSpec correlationStrategy(CorrelationStrategy correlationStrategy) {
        Assert.notNull((Object)correlationStrategy, (String)"'correlationStrategy' must not be null.");
        this.correlationStrategy = correlationStrategy;
        return this;
    }

    public BarrierSpec discardChannel(@Nullable MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
        return this;
    }

    public BarrierSpec discardChannel(@Nullable String discardChannelName) {
        this.discardChannelName = discardChannelName;
        return this;
    }

    public BarrierSpec triggerTimeout(long triggerTimeout) {
        this.triggerTimeout = triggerTimeout;
        return this;
    }

    @Override
    public Tuple2<ConsumerEndpointFactoryBean, BarrierMessageHandler> doGet() {
        this.handler = this.triggerTimeout == null ? new BarrierMessageHandler(this.timeout, this.outputProcessor, this.correlationStrategy) : new BarrierMessageHandler(this.timeout, this.triggerTimeout, this.outputProcessor, this.correlationStrategy);
        if (this.discardChannel != null) {
            ((BarrierMessageHandler)this.handler).setDiscardChannel(this.discardChannel);
        } else if (this.discardChannelName != null) {
            ((BarrierMessageHandler)this.handler).setDiscardChannelName(this.discardChannelName);
        }
        return super.doGet();
    }
}

