/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.util;

import com.signalfx.shaded.jetty.util.Callback;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingCallback
extends Callback.Nested {
    private final AtomicInteger count;

    public CountingCallback(Callback callback, int count) {
        super(callback);
        if (count < 1) {
            throw new IllegalArgumentException();
        }
        this.count = new AtomicInteger(count);
    }

    @Override
    public void succeeded() {
        int current;
        do {
            if ((current = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(current, current - 1));
        if (current == 1) {
            super.succeeded();
        }
    }

    @Override
    public void failed(Throwable failure) {
        int current;
        do {
            if ((current = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(current, 0));
        super.failed(failure);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

