/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.jr.type;

import com.signalfx.shaded.fasterxml.jackson.jr.type.ResolvedType;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TypeBindings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] NO_STRINGS = new String[0];
    private static final ResolvedType[] NO_TYPES = ResolvedType.NO_TYPES;
    private static final TypeBindings EMPTY = new TypeBindings(NO_STRINGS, NO_TYPES, null);
    private final String[] _names;
    private final ResolvedType[] _types;
    private final String[] _unboundVariables;
    private final int _hashCode;

    private TypeBindings(String[] stringArray, ResolvedType[] resolvedTypeArray, String[] stringArray2) {
        this._names = stringArray == null ? NO_STRINGS : stringArray;
        this._types = resolvedTypeArray == null ? NO_TYPES : resolvedTypeArray;
        int n = 1;
        int n2 = this._types.length;
        for (int i = 0; i < n2; ++i) {
            n += this._types[i].hashCode();
        }
        this._unboundVariables = stringArray2;
        this._hashCode = n;
    }

    public static TypeBindings emptyBindings() {
        return EMPTY;
    }

    public static TypeBindings create(Class<?> clazz, List<ResolvedType> list) {
        ResolvedType[] resolvedTypeArray = list == null || list.isEmpty() ? NO_TYPES : list.toArray(new ResolvedType[list.size()]);
        return TypeBindings.create(clazz, resolvedTypeArray);
    }

    public static TypeBindings create(Class<?> clazz, ResolvedType[] resolvedTypeArray) {
        String[] stringArray;
        TypeVariable<Class<?>>[] typeVariableArray;
        if (resolvedTypeArray == null) {
            resolvedTypeArray = NO_TYPES;
        }
        if ((typeVariableArray = clazz.getTypeParameters()).length == 0) {
            stringArray = NO_STRINGS;
        } else {
            int n = typeVariableArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = typeVariableArray[i].getName();
            }
        }
        return new TypeBindings(stringArray, resolvedTypeArray, null);
    }

    public TypeBindings withUnboundVariable(String string) {
        int n = this._unboundVariables == null ? 0 : this._unboundVariables.length;
        String[] stringArray = n == 0 ? new String[1] : Arrays.copyOf(this._unboundVariables, n + 1);
        stringArray[n] = string;
        return new TypeBindings(this._names, this._types, stringArray);
    }

    public ResolvedType findBoundType(String string) {
        int n = this._names.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this._names[i])) continue;
            return this._types[i];
        }
        return null;
    }

    public boolean isEmpty() {
        return this._types.length == 0;
    }

    public int size() {
        return this._types.length;
    }

    public String getBoundName(int n) {
        if (n < 0 || n >= this._names.length) {
            return null;
        }
        return this._names[n];
    }

    public ResolvedType getBoundType(int n) {
        if (n < 0 || n >= this._types.length) {
            return null;
        }
        return this._types[n];
    }

    public List<ResolvedType> getTypeParameters() {
        if (this._types.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._types);
    }

    public boolean hasUnbound(String string) {
        if (this._unboundVariables != null) {
            int n = this._unboundVariables.length;
            while (--n >= 0) {
                if (!string.equals(this._unboundVariables[n])) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this._types.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        int n = this._types.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder = this._types[i].appendDesc(stringBuilder);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        int n = this._types.length;
        TypeBindings typeBindings = (TypeBindings)object;
        if (n != typeBindings.size()) {
            return false;
        }
        ResolvedType[] resolvedTypeArray = typeBindings._types;
        for (int i = 0; i < n; ++i) {
            if (resolvedTypeArray[i].equals(this._types[i])) continue;
            return false;
        }
        return true;
    }

    protected ResolvedType[] typeParameterArray() {
        return this._types;
    }
}

