/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yubico.fido.metadata.FidoMetadataDownloaderException;
import com.yubico.fido.metadata.JacksonCodecs;
import com.yubico.fido.metadata.MetadataBLOB;
import com.yubico.fido.metadata.MetadataBLOBHeader;
import com.yubico.fido.metadata.MetadataBLOBPayload;
import com.yubico.fido.metadata.UnexpectedLegalHeader;
import com.yubico.internal.util.BinaryUtil;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.OptionalUtil;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.exception.Base64UrlException;
import com.yubico.webauthn.data.exception.HexException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FidoMetadataDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FidoMetadataDownloader.class);
    @NonNull
    private final Set<String> expectedLegalHeaders;
    private final X509Certificate trustRootCertificate;
    private final URL trustRootUrl;
    private final Set<ByteArray> trustRootSha256;
    private final File trustRootCacheFile;
    private final Supplier<Optional<ByteArray>> trustRootCacheSupplier;
    private final Consumer<ByteArray> trustRootCacheConsumer;
    private final String blobJwt;
    private final URL blobUrl;
    private final File blobCacheFile;
    private final Supplier<Optional<ByteArray>> blobCacheSupplier;
    private final Consumer<ByteArray> blobCacheConsumer;
    private final CertStore certStore;
    @NonNull
    private final Clock clock;
    private final KeyStore httpsTrustStore;
    private final boolean verifyDownloadsOnly;

    public static FidoMetadataDownloaderBuilder.Step1 builder() {
        return new FidoMetadataDownloaderBuilder.Step1();
    }

    public MetadataBLOB loadCachedBlob() throws CertPathValidatorException, InvalidAlgorithmParameterException, Base64UrlException, CertificateException, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, UnexpectedLegalHeader, DigestException, FidoMetadataDownloaderException {
        X509Certificate trustRoot = this.retrieveTrustRootCert();
        Optional<MetadataBLOB> explicit = this.loadExplicitBlobOnly(trustRoot);
        if (explicit.isPresent()) {
            log.debug("Explicit BLOB is set - disregarding cache and download.");
            return explicit.get();
        }
        Optional<MetadataBLOB> cached = this.loadCachedBlobOnly(trustRoot);
        if (cached.isPresent()) {
            log.debug("Cached BLOB exists, checking expiry date...");
            if (cached.get().getPayload().getNextUpdate().atStartOfDay().atZone(this.clock.getZone()).isAfter(this.clock.instant().atZone(this.clock.getZone()))) {
                log.debug("Cached BLOB has not yet expired - using cached BLOB.");
                return cached.get();
            }
            log.debug("Cached BLOB has expired.");
        } else {
            log.debug("Cached BLOB does not exist or is invalid.");
        }
        return this.refreshBlobInternal(trustRoot, cached).get();
    }

    public MetadataBLOB refreshBlob() throws CertPathValidatorException, InvalidAlgorithmParameterException, Base64UrlException, CertificateException, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, UnexpectedLegalHeader, DigestException, FidoMetadataDownloaderException {
        X509Certificate trustRoot = this.retrieveTrustRootCert();
        Optional<MetadataBLOB> explicit = this.loadExplicitBlobOnly(trustRoot);
        if (explicit.isPresent()) {
            log.debug("Explicit BLOB is set - disregarding cache and download.");
            return explicit.get();
        }
        Optional<MetadataBLOB> cached = this.loadCachedBlobOnly(trustRoot);
        if (cached.isPresent()) {
            log.debug("Cached BLOB exists, proceeding to compare against fresh BLOB...");
        } else {
            log.debug("Cached BLOB does not exist or is invalid.");
        }
        return this.refreshBlobInternal(trustRoot, cached).get();
    }

    private Optional<MetadataBLOB> refreshBlobInternal(@NonNull X509Certificate trustRoot, @NonNull Optional<MetadataBLOB> cached) throws CertPathValidatorException, InvalidAlgorithmParameterException, Base64UrlException, CertificateException, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, UnexpectedLegalHeader, FidoMetadataDownloaderException {
        if (trustRoot == null) {
            throw new NullPointerException("trustRoot is marked non-null but is null");
        }
        if (cached == null) {
            throw new NullPointerException("cached is marked non-null but is null");
        }
        try {
            log.debug("Attempting to download new BLOB...");
            ByteArray downloadedBytes = this.download(this.blobUrl);
            MetadataBLOB downloadedBlob = this.parseAndVerifyBlob(downloadedBytes, trustRoot);
            log.debug("New BLOB downloaded.");
            if (cached.isPresent()) {
                log.debug("Cached BLOB exists - checking if new BLOB has a higher \"no\"...");
                if (downloadedBlob.getPayload().getNo() <= cached.get().getPayload().getNo()) {
                    log.debug("New BLOB does not have a higher \"no\" - using cached BLOB instead.");
                    return cached;
                }
                log.debug("New BLOB has a higher \"no\" - proceeding with new BLOB.");
            }
            log.debug("Checking legalHeader in new BLOB...");
            if (!this.expectedLegalHeaders.contains(downloadedBlob.getPayload().getLegalHeader())) {
                throw new UnexpectedLegalHeader(cached.orElse(null), downloadedBlob);
            }
            log.debug("Writing new BLOB to cache...");
            if (this.blobCacheFile != null) {
                try (FileOutputStream f = new FileOutputStream(this.blobCacheFile);){
                    f.write(downloadedBytes.getBytes());
                }
            }
            if (this.blobCacheConsumer != null) {
                this.blobCacheConsumer.accept(downloadedBytes);
            }
            return Optional.of(downloadedBlob);
        }
        catch (FidoMetadataDownloaderException e) {
            if (e.getReason() == FidoMetadataDownloaderException.Reason.BAD_SIGNATURE && cached.isPresent()) {
                log.warn("New BLOB has bad signature - falling back to cached BLOB.");
                return cached;
            }
            throw e;
        }
        catch (Exception e) {
            if (cached.isPresent()) {
                log.warn("Failed to download new BLOB - falling back to cached BLOB.", (Throwable)e);
                return cached;
            }
            throw e;
        }
    }

    private X509Certificate retrieveTrustRootCert() throws CertificateException, DigestException, IOException, NoSuchAlgorithmException {
        ByteArray verifiedCachedContents;
        if (this.trustRootCertificate != null) {
            return this.trustRootCertificate;
        }
        Optional<ByteArray> cachedContents = this.trustRootCacheFile != null ? this.readCacheFile(this.trustRootCacheFile) : this.trustRootCacheSupplier.get();
        X509Certificate cert = null;
        if (cachedContents.isPresent() && (verifiedCachedContents = FidoMetadataDownloader.verifyHash(cachedContents.get(), this.trustRootSha256)) != null) {
            try {
                X509Certificate cachedCert = CertificateParser.parseDer((byte[])verifiedCachedContents.getBytes());
                cachedCert.checkValidity(Date.from(this.clock.instant()));
                cert = cachedCert;
            }
            catch (CertificateException cachedCert) {
                // empty catch block
            }
        }
        if (cert == null) {
            ByteArray downloaded = FidoMetadataDownloader.verifyHash(this.download(this.trustRootUrl), this.trustRootSha256);
            if (downloaded == null) {
                throw new DigestException("Downloaded trust root certificate matches none of the acceptable hashes.");
            }
            cert = CertificateParser.parseDer((byte[])downloaded.getBytes());
            cert.checkValidity(Date.from(this.clock.instant()));
            if (this.trustRootCacheFile != null) {
                try (FileOutputStream f = new FileOutputStream(this.trustRootCacheFile);){
                    f.write(downloaded.getBytes());
                }
            }
            if (this.trustRootCacheConsumer != null) {
                this.trustRootCacheConsumer.accept(downloaded);
            }
        }
        return cert;
    }

    private Optional<MetadataBLOB> loadExplicitBlobOnly(X509Certificate trustRootCertificate) throws Base64UrlException, CertPathValidatorException, CertificateException, IOException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, SignatureException, FidoMetadataDownloaderException {
        if (this.blobJwt != null) {
            return Optional.of(this.parseAndMaybeVerifyBlob(new ByteArray(this.blobJwt.getBytes(StandardCharsets.UTF_8)), trustRootCertificate));
        }
        return Optional.empty();
    }

    private Optional<MetadataBLOB> loadCachedBlobOnly(X509Certificate trustRootCertificate) {
        Optional<ByteArray> cachedContents;
        if (this.blobCacheFile != null) {
            log.debug("Attempting to read BLOB from cache file...");
            try {
                cachedContents = this.readCacheFile(this.blobCacheFile);
            }
            catch (IOException e) {
                return Optional.empty();
            }
        } else {
            log.debug("Attempting to read BLOB from cache Supplier...");
            cachedContents = this.blobCacheSupplier.get();
        }
        return cachedContents.map(cached -> {
            try {
                return this.parseAndMaybeVerifyBlob((ByteArray)cached, trustRootCertificate);
            }
            catch (Exception e) {
                log.warn("Failed to read or parse cached BLOB.", (Throwable)e);
                return null;
            }
        });
    }

    private Optional<ByteArray> readCacheFile(File cacheFile) throws IOException {
        if (cacheFile.exists() && cacheFile.canRead() && cacheFile.isFile()) {
            Optional<ByteArray> optional;
            FileInputStream f = new FileInputStream(cacheFile);
            try {
                optional = Optional.of(FidoMetadataDownloader.readAll(f));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        f.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("This exception should be impossible, please file a bug report.", e);
                }
            }
            f.close();
            return optional;
        }
        return Optional.empty();
    }

    private ByteArray download(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            if (this.httpsTrustStore != null) {
                try {
                    TrustManagerFactory trustMan = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustMan.init(this.httpsTrustStore);
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, trustMan.getTrustManagers(), null);
                    httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    throw new RuntimeException("Failed to initialize HTTPS trust store. This should be impossible, please file a bug report.", e);
                }
            }
            httpsConn.setRequestMethod("GET");
        }
        return FidoMetadataDownloader.readAll(conn.getInputStream());
    }

    private MetadataBLOB parseAndVerifyBlob(ByteArray jwt, X509Certificate trustRootCertificate) throws CertPathValidatorException, InvalidAlgorithmParameterException, CertificateException, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, Base64UrlException, FidoMetadataDownloaderException {
        return this.verifyBlob(FidoMetadataDownloader.parseBlob(jwt), trustRootCertificate);
    }

    private MetadataBLOB parseAndMaybeVerifyBlob(ByteArray jwt, X509Certificate trustRootCertificate) throws CertPathValidatorException, InvalidAlgorithmParameterException, CertificateException, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, Base64UrlException, FidoMetadataDownloaderException {
        if (this.verifyDownloadsOnly) {
            return FidoMetadataDownloader.parseBlob(jwt).blob;
        }
        return this.verifyBlob(FidoMetadataDownloader.parseBlob(jwt), trustRootCertificate);
    }

    private MetadataBLOB verifyBlob(ParseResult parseResult, X509Certificate trustRootCertificate) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertPathValidatorException, InvalidAlgorithmParameterException, FidoMetadataDownloaderException {
        Signature signature;
        MetadataBLOBHeader header = parseResult.blob.getHeader();
        List<X509Certificate> certChain = this.fetchHeaderCertChain(trustRootCertificate, header);
        X509Certificate leafCert = certChain.get(0);
        switch (header.getAlg()) {
            case "RS256": {
                signature = Signature.getInstance("SHA256withRSA");
                break;
            }
            case "ES256": {
                signature = Signature.getInstance("SHA256withECDSA");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplemented JWT verification algorithm: " + header.getAlg());
            }
        }
        signature.initVerify(leafCert.getPublicKey());
        signature.update((parseResult.jwtHeader.getBase64Url() + "." + parseResult.jwtPayload.getBase64Url()).getBytes(StandardCharsets.UTF_8));
        if (!signature.verify(parseResult.jwtSignature.getBytes())) {
            throw new FidoMetadataDownloaderException(FidoMetadataDownloaderException.Reason.BAD_SIGNATURE);
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
        CertPath blobCertPath = certFactory.generateCertPath(certChain);
        PKIXParameters pathParams = new PKIXParameters(Collections.singleton(new TrustAnchor(trustRootCertificate, null)));
        if (this.certStore != null) {
            pathParams.addCertStore(this.certStore);
        }
        this.fetchCrlDistributionPoints(certChain, certFactory).ifPresent(pathParams::addCertStore);
        pathParams.setDate(Date.from(this.clock.instant()));
        cpv.validate(blobCertPath, pathParams);
        return parseResult.blob;
    }

    static ParseResult parseBlob(ByteArray jwt) throws IOException, Base64UrlException {
        Scanner s = new Scanner(new ByteArrayInputStream(jwt.getBytes())).useDelimiter("\\.");
        ByteArray jwtHeader = ByteArray.fromBase64Url((String)s.next());
        ByteArray jwtPayload = ByteArray.fromBase64Url((String)s.next());
        ByteArray jwtSignature = ByteArray.fromBase64Url((String)s.next());
        ObjectMapper headerJsonMapper = JacksonCodecs.json().setBase64Variant(Base64Variants.MIME_NO_LINEFEEDS);
        return new ParseResult(new MetadataBLOB((MetadataBLOBHeader)headerJsonMapper.readValue(jwtHeader.getBytes(), MetadataBLOBHeader.class), (MetadataBLOBPayload)JacksonCodecs.jsonWithDefaultEnums().readValue(jwtPayload.getBytes(), MetadataBLOBPayload.class)), jwtHeader, jwtPayload, jwtSignature);
    }

    private static ByteArray readAll(InputStream is) throws IOException {
        return new ByteArray(BinaryUtil.readAll((InputStream)is));
    }

    private static ByteArray verifyHash(ByteArray contents, Set<ByteArray> acceptedCertSha256) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ByteArray hash = new ByteArray(digest.digest(contents.getBytes()));
        if (acceptedCertSha256.stream().anyMatch(arg_0 -> ((ByteArray)hash).equals(arg_0))) {
            return contents;
        }
        return null;
    }

    List<X509Certificate> fetchHeaderCertChain(X509Certificate trustRootCertificate, MetadataBLOBHeader header) throws IOException, CertificateException {
        if (header.getX5u().isPresent()) {
            URL x5u = header.getX5u().get();
            if (!(this.blobUrl == null || x5u.getHost().equals(this.blobUrl.getHost()) && x5u.getProtocol().equals(this.blobUrl.getProtocol()) && x5u.getPort() == this.blobUrl.getPort())) {
                throw new IllegalArgumentException(String.format("x5u in BLOB header must have same origin as the URL the BLOB was downloaded from. Expected origin of: %s ; found: %s", this.blobUrl, x5u));
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (String pem : new String(this.download(x5u).getBytes(), StandardCharsets.UTF_8).trim().split("\\n+-----END CERTIFICATE-----\\n+-----BEGIN CERTIFICATE-----\\n+")) {
                X509Certificate x509Certificate = CertificateParser.parsePem((String)pem);
                certs.add(x509Certificate);
            }
            return certs;
        }
        if (header.getX5c().isPresent()) {
            return header.getX5c().get();
        }
        return Collections.singletonList(trustRootCertificate);
    }

    private Optional<CertStore> fetchCrlDistributionPoints(List<X509Certificate> certChain, CertificateFactory certFactory) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        List crlDistributionPointUrls = certChain.stream().flatMap(cert -> {
            log.debug("Attempting to parse CRLDistributionPoints extension of cert: {}", (Object)cert.getSubjectX500Principal());
            try {
                return CertificateParser.parseCrlDistributionPointsExtension((X509Certificate)cert).getDistributionPoints().stream();
            }
            catch (Exception e) {
                log.warn("Failed to parse CRLDistributionPoints extension of cert: {}", (Object)cert.getSubjectX500Principal(), (Object)e);
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        if (crlDistributionPointUrls.isEmpty()) {
            return Optional.empty();
        }
        List crldpCrls = crlDistributionPointUrls.stream().map(crldpUrl -> {
            log.debug("Attempting to download CRL distribution point: {}", crldpUrl);
            try {
                return Optional.of(certFactory.generateCRL(new ByteArrayInputStream(this.download((URL)crldpUrl).getBytes())));
            }
            catch (CRLException e) {
                log.warn("Failed to import CRL from distribution point: {}", crldpUrl, (Object)e);
                return Optional.empty();
            }
            catch (Exception e) {
                log.warn("Failed to download CRL distribution point: {}", crldpUrl, (Object)e);
                return Optional.empty();
            }
        }).flatMap(OptionalUtil::stream).collect(Collectors.toList());
        return Optional.of(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crldpCrls)));
    }

    @Generated
    private FidoMetadataDownloader(@NonNull Set<String> expectedLegalHeaders, X509Certificate trustRootCertificate, URL trustRootUrl, Set<ByteArray> trustRootSha256, File trustRootCacheFile, Supplier<Optional<ByteArray>> trustRootCacheSupplier, Consumer<ByteArray> trustRootCacheConsumer, String blobJwt, URL blobUrl, File blobCacheFile, Supplier<Optional<ByteArray>> blobCacheSupplier, Consumer<ByteArray> blobCacheConsumer, CertStore certStore, @NonNull Clock clock, KeyStore httpsTrustStore, boolean verifyDownloadsOnly) {
        if (expectedLegalHeaders == null) {
            throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.expectedLegalHeaders = expectedLegalHeaders;
        this.trustRootCertificate = trustRootCertificate;
        this.trustRootUrl = trustRootUrl;
        this.trustRootSha256 = trustRootSha256;
        this.trustRootCacheFile = trustRootCacheFile;
        this.trustRootCacheSupplier = trustRootCacheSupplier;
        this.trustRootCacheConsumer = trustRootCacheConsumer;
        this.blobJwt = blobJwt;
        this.blobUrl = blobUrl;
        this.blobCacheFile = blobCacheFile;
        this.blobCacheSupplier = blobCacheSupplier;
        this.blobCacheConsumer = blobCacheConsumer;
        this.certStore = certStore;
        this.clock = clock;
        this.httpsTrustStore = httpsTrustStore;
        this.verifyDownloadsOnly = verifyDownloadsOnly;
    }

    public static class FidoMetadataDownloaderBuilder {
        @NonNull
        private final Set<String> expectedLegalHeaders;
        private final X509Certificate trustRootCertificate;
        private final URL trustRootUrl;
        private final Set<ByteArray> trustRootSha256;
        private final File trustRootCacheFile;
        private final Supplier<Optional<ByteArray>> trustRootCacheSupplier;
        private final Consumer<ByteArray> trustRootCacheConsumer;
        private final String blobJwt;
        private final URL blobUrl;
        private final File blobCacheFile;
        private final Supplier<Optional<ByteArray>> blobCacheSupplier;
        private final Consumer<ByteArray> blobCacheConsumer;
        private CertStore certStore = null;
        @NonNull
        private Clock clock = Clock.systemUTC();
        private KeyStore httpsTrustStore = null;
        private boolean verifyDownloadsOnly = false;

        public FidoMetadataDownloader build() {
            return new FidoMetadataDownloader(this.expectedLegalHeaders, this.trustRootCertificate, this.trustRootUrl, this.trustRootSha256, this.trustRootCacheFile, this.trustRootCacheSupplier, this.trustRootCacheConsumer, this.blobJwt, this.blobUrl, this.blobCacheFile, this.blobCacheSupplier, this.blobCacheConsumer, this.certStore, this.clock, this.httpsTrustStore, this.verifyDownloadsOnly);
        }

        private static FidoMetadataDownloaderBuilder finishRequiredSteps(Step5 step5, File blobCacheFile, Supplier<Optional<ByteArray>> blobCacheSupplier, Consumer<ByteArray> blobCacheConsumer) {
            return new FidoMetadataDownloaderBuilder(step5.step4.step3.step2.expectedLegalHeaders, step5.step4.step3.trustRootCertificate, step5.step4.step3.trustRootUrl, step5.step4.step3.trustRootSha256, step5.step4.trustRootCacheFile, step5.step4.trustRootCacheSupplier, step5.step4.trustRootCacheConsumer, step5.blobJwt, step5.blobUrl, blobCacheFile, blobCacheSupplier, blobCacheConsumer);
        }

        public FidoMetadataDownloaderBuilder clock(@NonNull Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            this.clock = clock;
            return this;
        }

        public FidoMetadataDownloaderBuilder useCrls(@NonNull Collection<CRL> crls) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            if (crls == null) {
                throw new NullPointerException("crls is marked non-null but is null");
            }
            return this.useCrls(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
        }

        public FidoMetadataDownloaderBuilder useCrls(CertStore certStore) {
            this.certStore = certStore;
            return this;
        }

        public FidoMetadataDownloaderBuilder trustHttpsCerts(X509Certificate ... certificates) {
            KeyStore trustStore;
            if (certificates == null) {
                throw new NullPointerException("certificates is marked non-null but is null");
            }
            try {
                trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Failed to instantiate or initialize KeyStore. This should not be possible, please file a bug report.", e);
            }
            for (X509Certificate cert : certificates) {
                try {
                    trustStore.setCertificateEntry(UUID.randomUUID().toString(), cert);
                }
                catch (KeyStoreException e) {
                    throw new RuntimeException("Failed to import HTTPS cert into KeyStore. This should not be possible, please file a bug report.", e);
                }
            }
            this.httpsTrustStore = trustStore;
            return this;
        }

        public FidoMetadataDownloaderBuilder verifyDownloadsOnly(boolean verifyDownloadsOnly) {
            this.verifyDownloadsOnly = verifyDownloadsOnly;
            return this;
        }

        @Generated
        private FidoMetadataDownloaderBuilder(@NonNull Set<String> expectedLegalHeaders, X509Certificate trustRootCertificate, URL trustRootUrl, Set<ByteArray> trustRootSha256, File trustRootCacheFile, Supplier<Optional<ByteArray>> trustRootCacheSupplier, Consumer<ByteArray> trustRootCacheConsumer, String blobJwt, URL blobUrl, File blobCacheFile, Supplier<Optional<ByteArray>> blobCacheSupplier, Consumer<ByteArray> blobCacheConsumer) {
            if (expectedLegalHeaders == null) {
                throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
            }
            this.expectedLegalHeaders = expectedLegalHeaders;
            this.trustRootCertificate = trustRootCertificate;
            this.trustRootUrl = trustRootUrl;
            this.trustRootSha256 = trustRootSha256;
            this.trustRootCacheFile = trustRootCacheFile;
            this.trustRootCacheSupplier = trustRootCacheSupplier;
            this.trustRootCacheConsumer = trustRootCacheConsumer;
            this.blobJwt = blobJwt;
            this.blobUrl = blobUrl;
            this.blobCacheFile = blobCacheFile;
            this.blobCacheSupplier = blobCacheSupplier;
            this.blobCacheConsumer = blobCacheConsumer;
        }

        public static class Step5 {
            @NonNull
            private final Step4 step4;
            private final String blobJwt;
            private final URL blobUrl;

            public FidoMetadataDownloaderBuilder useBlobCacheFile(@NonNull File cacheFile) {
                if (cacheFile == null) {
                    throw new NullPointerException("cacheFile is marked non-null but is null");
                }
                return FidoMetadataDownloaderBuilder.finishRequiredSteps(this, cacheFile, null, null);
            }

            public FidoMetadataDownloaderBuilder useBlobCache(@NonNull Supplier<Optional<ByteArray>> getCachedBlob, @NonNull Consumer<ByteArray> writeCachedBlob) {
                if (getCachedBlob == null) {
                    throw new NullPointerException("getCachedBlob is marked non-null but is null");
                }
                if (writeCachedBlob == null) {
                    throw new NullPointerException("writeCachedBlob is marked non-null but is null");
                }
                return FidoMetadataDownloaderBuilder.finishRequiredSteps(this, null, getCachedBlob, writeCachedBlob);
            }

            @Generated
            private Step5(@NonNull Step4 step4, String blobJwt, URL blobUrl) {
                if (step4 == null) {
                    throw new NullPointerException("step4 is marked non-null but is null");
                }
                this.step4 = step4;
                this.blobJwt = blobJwt;
                this.blobUrl = blobUrl;
            }
        }

        public static class Step4 {
            @NonNull
            private final Step3 step3;
            private final File trustRootCacheFile;
            private final Supplier<Optional<ByteArray>> trustRootCacheSupplier;
            private final Consumer<ByteArray> trustRootCacheConsumer;

            public Step5 useDefaultBlob() {
                try {
                    return this.downloadBlob(new URL("https://mds.fidoalliance.org/"));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Bad hard-coded trust root certificate URL. Please file a bug report.", e);
                }
            }

            public Step5 downloadBlob(@NonNull URL url) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                return new Step5(this, null, url);
            }

            public FidoMetadataDownloaderBuilder useBlob(@NonNull String blobJwt) {
                if (blobJwt == null) {
                    throw new NullPointerException("blobJwt is marked non-null but is null");
                }
                return FidoMetadataDownloaderBuilder.finishRequiredSteps(new Step5(this, blobJwt, null), null, null, null);
            }

            @Generated
            private Step4(@NonNull Step3 step3, File trustRootCacheFile, Supplier<Optional<ByteArray>> trustRootCacheSupplier, Consumer<ByteArray> trustRootCacheConsumer) {
                if (step3 == null) {
                    throw new NullPointerException("step3 is marked non-null but is null");
                }
                this.step3 = step3;
                this.trustRootCacheFile = trustRootCacheFile;
                this.trustRootCacheSupplier = trustRootCacheSupplier;
                this.trustRootCacheConsumer = trustRootCacheConsumer;
            }
        }

        public static class Step3 {
            @NonNull
            private final Step2 step2;
            private final X509Certificate trustRootCertificate;
            private final URL trustRootUrl;
            private final Set<ByteArray> trustRootSha256;

            public Step4 useTrustRootCacheFile(@NonNull File cacheFile) {
                if (cacheFile == null) {
                    throw new NullPointerException("cacheFile is marked non-null but is null");
                }
                return new Step4(this, cacheFile, null, null);
            }

            public Step4 useTrustRootCache(@NonNull Supplier<Optional<ByteArray>> getCachedTrustRootCert, @NonNull Consumer<ByteArray> writeCachedTrustRootCert) {
                if (getCachedTrustRootCert == null) {
                    throw new NullPointerException("getCachedTrustRootCert is marked non-null but is null");
                }
                if (writeCachedTrustRootCert == null) {
                    throw new NullPointerException("writeCachedTrustRootCert is marked non-null but is null");
                }
                return new Step4(this, null, getCachedTrustRootCert, writeCachedTrustRootCert);
            }

            @Generated
            private Step3(@NonNull Step2 step2, X509Certificate trustRootCertificate, URL trustRootUrl, Set<ByteArray> trustRootSha256) {
                if (step2 == null) {
                    throw new NullPointerException("step2 is marked non-null but is null");
                }
                this.step2 = step2;
                this.trustRootCertificate = trustRootCertificate;
                this.trustRootUrl = trustRootUrl;
                this.trustRootSha256 = trustRootSha256;
            }
        }

        public static class Step2 {
            @NonNull
            private final Set<String> expectedLegalHeaders;

            public Step3 useDefaultTrustRoot() {
                try {
                    return this.downloadTrustRoot(new URL("https://secure.globalsign.com/cacert/root-r3.crt"), Collections.singleton(ByteArray.fromHex((String)"cbb522d7b7f127ad6a0113865bdf1cd4102e7d0759af635a7cf4720dc963c53b")));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Bad hard-coded trust root certificate URL. Please file a bug report.", e);
                }
                catch (HexException e) {
                    throw new RuntimeException("Bad hard-coded trust root certificate hash. Please file a bug report.", e);
                }
            }

            public Step3 downloadTrustRoot(@NonNull URL url, @NonNull Set<ByteArray> acceptedCertSha256) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                if (acceptedCertSha256 == null) {
                    throw new NullPointerException("acceptedCertSha256 is marked non-null but is null");
                }
                if (!"https".equals(url.getProtocol())) {
                    throw new IllegalArgumentException("Trust certificate download URL must be a HTTPS URL.");
                }
                return new Step3(this, null, url, acceptedCertSha256);
            }

            public Step4 useTrustRoot(@NonNull X509Certificate trustRootCertificate) {
                if (trustRootCertificate == null) {
                    throw new NullPointerException("trustRootCertificate is marked non-null but is null");
                }
                return new Step4(new Step3(this, trustRootCertificate, null, null), null, null, null);
            }

            @Generated
            private Step2(@NonNull Set<String> expectedLegalHeaders) {
                if (expectedLegalHeaders == null) {
                    throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
                }
                this.expectedLegalHeaders = expectedLegalHeaders;
            }
        }

        public static class Step1 {
            public Step2 expectLegalHeader(String ... expectedLegalHeaders) {
                if (expectedLegalHeaders == null) {
                    throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
                }
                return new Step2(Stream.of(expectedLegalHeaders).collect(Collectors.toSet()));
            }

            @Generated
            private Step1() {
            }
        }
    }

    static final class ParseResult {
        private final MetadataBLOB blob;
        private final ByteArray jwtHeader;
        private final ByteArray jwtPayload;
        private final ByteArray jwtSignature;

        @Generated
        public ParseResult(MetadataBLOB blob, ByteArray jwtHeader, ByteArray jwtPayload, ByteArray jwtSignature) {
            this.blob = blob;
            this.jwtHeader = jwtHeader;
            this.jwtPayload = jwtPayload;
            this.jwtSignature = jwtSignature;
        }

        @Generated
        public MetadataBLOB getBlob() {
            return this.blob;
        }

        @Generated
        public ByteArray getJwtHeader() {
            return this.jwtHeader;
        }

        @Generated
        public ByteArray getJwtPayload() {
            return this.jwtPayload;
        }

        @Generated
        public ByteArray getJwtSignature() {
            return this.jwtSignature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseResult)) {
                return false;
            }
            ParseResult other = (ParseResult)o;
            MetadataBLOB this$blob = this.getBlob();
            MetadataBLOB other$blob = other.getBlob();
            if (this$blob == null ? other$blob != null : !((Object)this$blob).equals(other$blob)) {
                return false;
            }
            ByteArray this$jwtHeader = this.getJwtHeader();
            ByteArray other$jwtHeader = other.getJwtHeader();
            if (this$jwtHeader == null ? other$jwtHeader != null : !this$jwtHeader.equals(other$jwtHeader)) {
                return false;
            }
            ByteArray this$jwtPayload = this.getJwtPayload();
            ByteArray other$jwtPayload = other.getJwtPayload();
            if (this$jwtPayload == null ? other$jwtPayload != null : !this$jwtPayload.equals(other$jwtPayload)) {
                return false;
            }
            ByteArray this$jwtSignature = this.getJwtSignature();
            ByteArray other$jwtSignature = other.getJwtSignature();
            return !(this$jwtSignature == null ? other$jwtSignature != null : !this$jwtSignature.equals(other$jwtSignature));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MetadataBLOB $blob = this.getBlob();
            result = result * 59 + ($blob == null ? 43 : ((Object)$blob).hashCode());
            ByteArray $jwtHeader = this.getJwtHeader();
            result = result * 59 + ($jwtHeader == null ? 43 : $jwtHeader.hashCode());
            ByteArray $jwtPayload = this.getJwtPayload();
            result = result * 59 + ($jwtPayload == null ? 43 : $jwtPayload.hashCode());
            ByteArray $jwtSignature = this.getJwtSignature();
            result = result * 59 + ($jwtSignature == null ? 43 : $jwtSignature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FidoMetadataDownloader.ParseResult(blob=" + this.getBlob() + ", jwtHeader=" + this.getJwtHeader() + ", jwtPayload=" + this.getJwtPayload() + ", jwtSignature=" + this.getJwtSignature() + ")";
        }
    }
}

