/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security.jws;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSEntraJWSVerifierCacheLoader
implements CacheLoader<String, JWSVerifier> {
    protected static final Logger LOG = LoggerFactory.getLogger(MSEntraJWSVerifierCacheLoader.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final String tenantId;
    protected final String appId;

    public MSEntraJWSVerifierCacheLoader(String tenantId, String appId) {
        this.tenantId = tenantId;
        this.appId = appId;
    }

    protected String getOpenIDMetadataDocumentUrl() {
        return String.format("https://login.microsoftonline.com/%s/.well-known/openid-configuration%s", Optional.ofNullable(this.tenantId).orElse("common"), Optional.ofNullable(this.appId).map(i -> String.format("?appid=%s", i)).orElse(""));
    }

    protected String extractJwksUri(String openIdMetadataDocument) {
        try {
            return MAPPER.readTree(openIdMetadataDocument).get("jwks_uri").asText();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Extracting value of 'jwks_url' key from OpenID Metadata JSON document for Microsoft Entra failed:", e);
        }
    }

    protected String fetchDocument(String url) {
        try {
            HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create(url)).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 400) {
                throw new IllegalStateException(String.format("Received HTTP status code %d", response.statusCode()));
            }
            return response.body();
        }
        catch (IOException | IllegalStateException | InterruptedException e) {
            throw new IllegalStateException(String.format("Fetching JSON document for Microsoft Entra from '%s' failed:", url), e);
        }
    }

    protected Map<String, JWSVerifier> parseJsonWebKeySet(String jsonWebKeySet) {
        List fetchedKeys;
        try {
            fetchedKeys = JWKSet.parse((String)jsonWebKeySet).getKeys();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Parsing JSON Web Key Set for MS Entra failed:", e);
        }
        HashMap<String, JWSVerifier> verifiers = new HashMap<String, JWSVerifier>();
        for (JWK key : fetchedKeys) {
            if (!(key instanceof AsymmetricJWK)) {
                LOG.warn("Skipped non-asymmetric JSON Web Key with key id '{}' from retrieved JSON Web Key Set for Microsoft Entra", (Object)key.getKeyID());
                continue;
            }
            try {
                PublicKey publicKey;
                PublicKey pubKey = ((AsymmetricJWK)key).toPublicKey();
                Objects.requireNonNull(pubKey);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RSAPublicKey.class, ECPublicKey.class}, (Object)publicKey, n)) {
                    case 0: {
                        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                        verifiers.put(key.getKeyID(), (JWSVerifier)new RSASSAVerifier(rsaPublicKey));
                        break;
                    }
                    case 1: {
                        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
                        verifiers.put(key.getKeyID(), (JWSVerifier)new ECDSAVerifier(ecPublicKey));
                        break;
                    }
                }
            }
            catch (JOSEException e) {
                throw new IllegalArgumentException("Extracting public key from asymmetric JSON Web Key from retrieved JSON Web Key Set for Microsoft Entra failed:", e);
            }
        }
        return verifiers;
    }

    public JWSVerifier load(String key) throws CacheLoaderException {
        return this.loadAll(Set.of(key)).get(key);
    }

    public Map<String, JWSVerifier> loadAll(Iterable<? extends String> keys) throws CacheLoaderException {
        String openIdDocUrl = this.getOpenIDMetadataDocumentUrl();
        String openIdDoc = this.fetchDocument(openIdDocUrl);
        String jwksUri = this.extractJwksUri(openIdDoc);
        String jwks = this.fetchDocument(jwksUri);
        return this.parseJsonWebKeySet(jwks);
    }
}

