/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthAccessTokenProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public record OAuth20AccessTokenExpirationPolicyBuilder(CasConfigurationProperties casProperties) implements ExpirationPolicyBuilder<OAuth20AccessToken>
{
    private static final long serialVersionUID = -3597980180617072826L;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        OAuthAccessTokenProperties oauth = this.casProperties.getAuthn().getOauth().getAccessToken();
        if (this.casProperties.getTicket().isTrackDescendantTickets()) {
            return new OAuth20AccessTokenExpirationPolicy(Beans.newDuration((String)oauth.getMaxTimeToLiveInSeconds()).toSeconds(), Beans.newDuration((String)oauth.getTimeToKillInSeconds()).toSeconds());
        }
        return new OAuth20AccessTokenExpirationPolicy.OAuthAccessTokenSovereignExpirationPolicy(Beans.newDuration((String)oauth.getMaxTimeToLiveInSeconds()).toSeconds(), Beans.newDuration((String)oauth.getTimeToKillInSeconds()).toSeconds());
    }
}

