/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.discovery;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.pac4j.discovery.DelegatedAuthenticationDynamicDiscoveryProvider;
import org.apereo.cas.pac4j.discovery.DelegatedAuthenticationDynamicDiscoveryProviderLocator;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.pac4j.core.client.IndirectClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DefaultDelegatedAuthenticationDynamicDiscoveryProviderLocator
implements DelegatedAuthenticationDynamicDiscoveryProviderLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedAuthenticationDynamicDiscoveryProviderLocator.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final DelegatedClientIdentityProviderConfigurationProducer providerProducer;
    private final DelegatedIdentityProviders identityProviders;
    private final PrincipalResolver principalResolver;
    private final PrincipalFactory clientPrincipalFactory;
    private final CasConfigurationProperties properties;

    public Optional<IndirectClient> locate(DelegatedAuthenticationDynamicDiscoveryProviderLocator.DynamicDiscoveryProviderRequest request) throws Throwable {
        Resource resource = this.properties.getAuthn().getPac4j().getCore().getDiscoverySelection().getJson().getLocation();
        Map mappings = (Map)MAPPER.readValue(resource.getInputStream(), (TypeReference)new TypeReference<Map<String, DelegatedAuthenticationDynamicDiscoveryProvider>>(this){});
        Principal principal = this.resolvePrincipal(request);
        LOGGER.debug("Resolved principal to be [{}]", (Object)principal);
        return mappings.entrySet().stream().sorted(Comparator.comparingInt(o -> ((DelegatedAuthenticationDynamicDiscoveryProvider)o.getValue()).getOrder())).map(entry -> this.getMatchingProvider(principal, (String)entry.getKey(), (DelegatedAuthenticationDynamicDiscoveryProvider)entry.getValue())).filter(Objects::nonNull).map(provider -> this.identityProviders.findClient(provider.getClientName())).flatMap(Optional::stream).map(IndirectClient.class::cast).findFirst();
    }

    protected Principal resolvePrincipal(DelegatedAuthenticationDynamicDiscoveryProviderLocator.DynamicDiscoveryProviderRequest request) throws Throwable {
        String userId = request.getUserId();
        Principal resolvedPrincipal = this.principalResolver.resolve((Credential)new BasicIdentifiableCredential(userId));
        if (resolvedPrincipal instanceof NullPrincipal) {
            LOGGER.debug("No principal was resolved. Falling back to the username [{}] from the credentials.", (Object)userId);
            return this.clientPrincipalFactory.createPrincipal(userId);
        }
        return resolvedPrincipal;
    }

    protected DelegatedAuthenticationDynamicDiscoveryProvider getMatchingProvider(Principal principal, String keyPattern, DelegatedAuthenticationDynamicDiscoveryProvider provider) {
        String attrName = this.properties.getAuthn().getPac4j().getCore().getDiscoverySelection().getJson().getPrincipalAttribute();
        if (StringUtils.isNotBlank((CharSequence)attrName) && principal.getAttributes().containsKey(attrName)) {
            List attrValues = (List)principal.getAttributes().get(attrName);
            LOGGER.debug("Checking attribute values [{}] against [{}]", (Object)attrValues, (Object)keyPattern);
            return attrValues.stream().anyMatch(value -> RegexUtils.find((String)keyPattern, (String)value.toString())) ? provider : null;
        }
        return RegexUtils.find((String)keyPattern, (String)principal.getId()) ? provider : null;
    }

    @Generated
    public DefaultDelegatedAuthenticationDynamicDiscoveryProviderLocator(DelegatedClientIdentityProviderConfigurationProducer providerProducer, DelegatedIdentityProviders identityProviders, PrincipalResolver principalResolver, PrincipalFactory clientPrincipalFactory, CasConfigurationProperties properties) {
        this.providerProducer = providerProducer;
        this.identityProviders = identityProviders;
        this.principalResolver = principalResolver;
        this.clientPrincipalFactory = clientPrincipalFactory;
        this.properties = properties;
    }

    @Generated
    public DelegatedClientIdentityProviderConfigurationProducer getProviderProducer() {
        return this.providerProducer;
    }

    @Generated
    public DelegatedIdentityProviders getIdentityProviders() {
        return this.identityProviders;
    }

    @Generated
    public PrincipalResolver getPrincipalResolver() {
        return this.principalResolver;
    }

    @Generated
    public PrincipalFactory getClientPrincipalFactory() {
        return this.clientPrincipalFactory;
    }

    @Generated
    public CasConfigurationProperties getProperties() {
        return this.properties;
    }
}

