/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.passwordless.DuoSecurityPasswordlessUserAccountStore;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityVerifyPasswordlessAuthenticationAction;
import org.apereo.cas.api.PasswordlessUserAccountCustomizer;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnFeaturesEnabled;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeaturesEnabled(value={@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordlessAuthn}), @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthentication}, module="duo")})
@ConditionalOnClass(value={PasswordlessUserAccountStore.class})
@Configuration(value="DuoSecurityPasswordlessAuthenticationConfiguration", proxyBeanMethods=false)
class DuoSecurityPasswordlessAuthenticationConfiguration {
    DuoSecurityPasswordlessAuthenticationConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"duoSecurityPasswordlessUserAccountStore"})
    public BeanSupplier<PasswordlessUserAccountStore> duoSecurityPasswordlessUserAccountStore(List<PasswordlessUserAccountCustomizer> customizerList, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return BeanSupplier.of(PasswordlessUserAccountStore.class).alwaysMatch().supply(() -> new DuoSecurityPasswordlessUserAccountStore(applicationContext, customizerList));
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"duoSecurityVerifyPasswordlessAuthenticationAction"})
    public Action duoSecurityVerifyPasswordlessAuthenticationAction(@Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="duoAuthenticationWebflowEventResolver") CasWebflowEventResolver duoAuthenticationWebflowEventResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityVerifyPasswordlessAuthenticationAction(authenticationSystemSupport, duoAuthenticationWebflowEventResolver)).otherwiseProxy().get()).withId("duoSecurityVerifyPasswordlessAuthenticationAction").build().get();
    }
}

