/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.services.BaseRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RemoteEndpointServiceAccessStrategy
extends BaseRegisteredServiceAccessStrategy {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private static final long serialVersionUID = -1108201604115278440L;
    private String endpointUrl;
    private String acceptableResponseCodes;
    private String method = "GET";
    private Map<String, String> headers = new TreeMap<String, String>();

    public boolean authorizeRequest(RegisteredServiceAccessStrategyRequest request) {
        return (Boolean)Unchecked.supplier(() -> {
            HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.valueOf((String)this.method)).url(SpringExpressionLanguageValueResolver.getInstance().resolve(this.endpointUrl)).headers(this.headers).parameters(CollectionUtils.wrap((String)"username", (Object)request.getPrincipalId())).entity(MAPPER.writeValueAsString((Object)request)).build();
            HttpResponse response = HttpUtils.execute((HttpExecutionRequest)exec);
            Set currentCodes = StringUtils.commaDelimitedListToSet((String)this.acceptableResponseCodes);
            return response != null && currentCodes.contains(String.valueOf(response.getCode()));
        }).get();
    }

    @Override
    @Generated
    public String toString() {
        return "RemoteEndpointServiceAccessStrategy(super=" + super.toString() + ", endpointUrl=" + this.endpointUrl + ", acceptableResponseCodes=" + this.acceptableResponseCodes + ", method=" + this.method + ", headers=" + String.valueOf(this.headers) + ")";
    }

    @Generated
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Generated
    public String getAcceptableResponseCodes() {
        return this.acceptableResponseCodes;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public RemoteEndpointServiceAccessStrategy setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    @Generated
    public RemoteEndpointServiceAccessStrategy setAcceptableResponseCodes(String acceptableResponseCodes) {
        this.acceptableResponseCodes = acceptableResponseCodes;
        return this;
    }

    @Generated
    public RemoteEndpointServiceAccessStrategy setMethod(String method) {
        this.method = method;
        return this;
    }

    @Generated
    public RemoteEndpointServiceAccessStrategy setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteEndpointServiceAccessStrategy)) {
            return false;
        }
        RemoteEndpointServiceAccessStrategy other = (RemoteEndpointServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$endpointUrl = this.endpointUrl;
        String other$endpointUrl = other.endpointUrl;
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        String this$acceptableResponseCodes = this.acceptableResponseCodes;
        String other$acceptableResponseCodes = other.acceptableResponseCodes;
        if (this$acceptableResponseCodes == null ? other$acceptableResponseCodes != null : !this$acceptableResponseCodes.equals(other$acceptableResponseCodes)) {
            return false;
        }
        String this$method = this.method;
        String other$method = other.method;
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, String> this$headers = this.headers;
        Map<String, String> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoteEndpointServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $endpointUrl = this.endpointUrl;
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        String $acceptableResponseCodes = this.acceptableResponseCodes;
        result = result * 59 + ($acceptableResponseCodes == null ? 43 : $acceptableResponseCodes.hashCode());
        String $method = this.method;
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, String> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    public RemoteEndpointServiceAccessStrategy() {
    }
}

