/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.atlas.impl.DataExpr;
import com.netflix.spectator.atlas.impl.Parser;

public final class Subscription {
    private String id;
    private String exprType;
    private String expression;
    private long frequency;
    private DataExpr expr;

    public DataExpr dataExpr() {
        if (this.expr == null) {
            this.expr = Parser.parseDataExpr(this.expression);
        }
        return this.expr;
    }

    public boolean isTimeSeries() {
        return this.exprType == null || "TIME_SERIES".equals(this.exprType);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Subscription withId(String id) {
        this.id = id;
        return this;
    }

    public String getExprType() {
        return this.exprType;
    }

    public void setExprType(String exprType) {
        this.exprType = exprType;
    }

    public Subscription withExprType(String exprType) {
        this.setExprType(exprType);
        return this;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.expr = null;
    }

    public Subscription withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public Subscription withFrequency(long frequency) {
        this.frequency = frequency;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return this.frequency == that.frequency && this.equalsOrNull(this.id, that.id) && this.equalsOrNull(this.exprType, that.exprType) && this.equalsOrNull(this.expression, that.expression);
    }

    private boolean equalsOrNull(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public int hashCode() {
        int result = this.hashCodeOrZero(this.id);
        result = 31 * result + this.hashCodeOrZero(this.exprType);
        result = 31 * result + this.hashCodeOrZero(this.expression);
        result = 31 * result + (int)(this.frequency ^ this.frequency >>> 32);
        return result;
    }

    private int hashCodeOrZero(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public String toString() {
        return "Subscription(" + this.id + "," + this.exprType + ",[" + this.expression + "]," + this.frequency + ")";
    }
}

