/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;

public class RemoteLogSegmentMetadataSnapshot
extends RemoteLogMetadata {
    private final Uuid segmentId;
    private final long startOffset;
    private final long endOffset;
    private final long maxTimestampMs;
    private final NavigableMap<Integer, Long> segmentLeaderEpochs;
    private final int segmentSizeInBytes;
    private final Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata;
    private final RemoteLogSegmentState state;

    public RemoteLogSegmentMetadataSnapshot(Uuid segmentId, long startOffset, long endOffset, long maxTimestampMs, int brokerId, long eventTimestampMs, int segmentSizeInBytes, Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata, RemoteLogSegmentState state, Map<Integer, Long> segmentLeaderEpochs) {
        super(brokerId, eventTimestampMs);
        this.segmentId = Objects.requireNonNull(segmentId, "remoteLogSegmentId can not be null");
        this.state = Objects.requireNonNull(state, "state can not be null");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.maxTimestampMs = maxTimestampMs;
        this.segmentSizeInBytes = segmentSizeInBytes;
        this.customMetadata = Objects.requireNonNull(customMetadata, "customMetadata can not be null");
        if (segmentLeaderEpochs == null || segmentLeaderEpochs.isEmpty()) {
            throw new IllegalArgumentException("segmentLeaderEpochs can not be null or empty");
        }
        this.segmentLeaderEpochs = Collections.unmodifiableNavigableMap(new TreeMap<Integer, Long>(segmentLeaderEpochs));
    }

    public static RemoteLogSegmentMetadataSnapshot create(RemoteLogSegmentMetadata metadata) {
        return new RemoteLogSegmentMetadataSnapshot(metadata.remoteLogSegmentId().id(), metadata.startOffset(), metadata.endOffset(), metadata.maxTimestampMs(), metadata.brokerId(), metadata.eventTimestampMs(), metadata.segmentSizeInBytes(), metadata.customMetadata(), metadata.state(), metadata.segmentLeaderEpochs());
    }

    public Uuid segmentId() {
        return this.segmentId;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public int segmentSizeInBytes() {
        return this.segmentSizeInBytes;
    }

    public long maxTimestampMs() {
        return this.maxTimestampMs;
    }

    public NavigableMap<Integer, Long> segmentLeaderEpochs() {
        return this.segmentLeaderEpochs;
    }

    public Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata() {
        return this.customMetadata;
    }

    public RemoteLogSegmentState state() {
        return this.state;
    }

    public TopicIdPartition topicIdPartition() {
        throw new UnsupportedOperationException("This metadata does not have topic partition with it.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteLogSegmentMetadataSnapshot)) {
            return false;
        }
        RemoteLogSegmentMetadataSnapshot that = (RemoteLogSegmentMetadataSnapshot)((Object)o);
        return this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.maxTimestampMs == that.maxTimestampMs && this.segmentSizeInBytes == that.segmentSizeInBytes && Objects.equals(this.customMetadata, that.customMetadata) && Objects.equals(this.segmentId, that.segmentId) && Objects.equals(this.segmentLeaderEpochs, that.segmentLeaderEpochs) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(this.segmentId, this.startOffset, this.endOffset, this.maxTimestampMs, this.segmentLeaderEpochs, this.segmentSizeInBytes, this.customMetadata, this.state);
    }

    public String toString() {
        return "RemoteLogSegmentMetadataSnapshot{segmentId=" + this.segmentId + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", maxTimestampMs=" + this.maxTimestampMs + ", segmentLeaderEpochs=" + this.segmentLeaderEpochs + ", segmentSizeInBytes=" + this.segmentSizeInBytes + ", customMetadata=" + this.customMetadata + ", state=" + this.state + '}';
    }
}

