/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.attribute.AbstractDefaultAttributePersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.merger.MultivaluedAttributeMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAggregatingDefaultQueryPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAggregatingDefaultQueryPersonAttributeDao.class);
    protected List<PersonAttributeDao> personAttributeDaos;
    protected AttributeMerger attributeMerger = new MultivaluedAttributeMerger();
    protected boolean recoverExceptions = true;
    protected boolean stopOnSuccess;
    protected boolean requireAll;

    @Override
    public String[] getId() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getClass().getSimpleName());
        this.personAttributeDaos.forEach(dao -> ids.addAll(Arrays.asList(dao.getId())));
        return ids.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        Set<Object> results = null;
        boolean isFirstQuery = true;
        for (PersonAttributeDao currentlyConsidering : this.personAttributeDaos) {
            if (filter != null && !filter.choosePersonAttributeDao(currentlyConsidering)) continue;
            boolean handledException = false;
            Set<PersonAttributes> currentPeople = null;
            try {
                currentPeople = this.getAttributesFromDao(query, isFirstQuery, currentlyConsidering, results, filter);
                isFirstQuery = false;
                LOGGER.debug("Retrieved attributes=[{}] for query=[{}], isFirstQuery=[{}], currentlyConsidering=[{}], resultAttributes=[{}]", new Object[]{currentPeople, query, isFirstQuery, currentlyConsidering, results});
            }
            catch (Exception rte) {
                boolean bl = handledException = handledException || this.handleRuntimeException(currentlyConsidering, rte);
            }
            if (currentPeople != null) {
                results = results == null ? new LinkedHashSet<PersonAttributes>(currentPeople) : this.attributeMerger.mergeResults(results, currentPeople);
            } else if (this.requireAll) {
                LOGGER.debug("Attribute repository dao [{}] did not resolve a person and configuration requires all sources to produce valid results. ", (Object)currentlyConsidering);
                return null;
            }
            if (!this.stopOnSuccess || handledException) continue;
            LOGGER.debug("Successfully retrieved attributes from a child DAO and stopOnSuccess is true, stopping iteration of child DAOs");
            break;
        }
        if (results == null) {
            return null;
        }
        LOGGER.debug("Aggregated search results [{}] for query [{}]", results, query);
        return Set.copyOf(results);
    }

    private boolean handleRuntimeException(PersonAttributeDao currentlyConsidering, Exception ex) {
        RuntimeException rte;
        if (this.recoverExceptions) {
            LOGGER.warn("Recovering From Exception thrown by [{}]", (Object)currentlyConsidering, (Object)ex);
            return true;
        }
        LOGGER.error("Failing From Exception thrown by [{}]", (Object)currentlyConsidering, (Object)ex);
        throw ex instanceof RuntimeException ? (rte = (RuntimeException)ex) : new RuntimeException(ex);
    }

    protected abstract Set<PersonAttributes> getAttributesFromDao(Map<String, List<Object>> var1, boolean var2, PersonAttributeDao var3, Set<PersonAttributes> var4, PersonAttributeDaoFilter var5);

    public final Set<String> getPossibleUserAttributeNames(PersonAttributeDaoFilter filter) {
        Set attrNames = null;
        for (PersonAttributeDao currentDao : this.personAttributeDaos) {
            if (filter != null && !filter.choosePersonAttributeDao(currentDao)) continue;
            boolean handledException = false;
            Set currentDaoAttrNames = null;
            try {
                currentDaoAttrNames = currentDao.getPossibleUserAttributeNames(filter);
                LOGGER.debug("Retrieved possible attribute names [{}] from [{}]", (Object)currentDaoAttrNames, (Object)currentDao);
            }
            catch (Exception rte) {
                boolean bl = handledException = handledException || this.handleRuntimeException(currentDao, rte);
            }
            if (currentDaoAttrNames != null) {
                if (attrNames == null) {
                    attrNames = new LinkedHashSet();
                }
                attrNames = this.attributeMerger.mergePossibleUserAttributeNames(attrNames, currentDaoAttrNames);
            }
            if (!this.stopOnSuccess || handledException) continue;
            LOGGER.debug("Successfully retrieved possible user attributes from a child DAO and stopOnSuccess is true, stopping iteration of child DAOs");
            break;
        }
        LOGGER.debug("Aggregated possible attribute names [{}]", attrNames);
        if (attrNames == null) {
            return null;
        }
        return Set.copyOf(attrNames);
    }

    @JsonIgnore
    public Set<String> getAvailableQueryAttributes(PersonAttributeDaoFilter filter) {
        Set queryAttrs = null;
        for (PersonAttributeDao currentDao : this.personAttributeDaos) {
            if (filter != null && !filter.choosePersonAttributeDao(currentDao)) continue;
            boolean handledException = false;
            Set currentDaoQueryAttrs = null;
            try {
                currentDaoQueryAttrs = currentDao.getAvailableQueryAttributes(filter);
                LOGGER.debug("Retrieved possible query attributes [{}] from [{}]", (Object)currentDaoQueryAttrs, (Object)currentDao);
            }
            catch (Exception rte) {
                boolean bl = handledException = handledException || this.handleRuntimeException(currentDao, rte);
            }
            if (currentDaoQueryAttrs != null) {
                if (queryAttrs == null) {
                    queryAttrs = new LinkedHashSet();
                }
                queryAttrs = this.attributeMerger.mergeAvailableQueryAttributes(queryAttrs, currentDaoQueryAttrs);
            }
            if (!this.stopOnSuccess || handledException) continue;
            LOGGER.debug("Successfully retrieved available query attributes from a child DAO and stopOnSuccess is true, stopping iteration of child DAOs");
            break;
        }
        LOGGER.debug("Aggregated possible query attributes [{}]", queryAttrs);
        if (queryAttrs == null) {
            return null;
        }
        return Set.copyOf(queryAttrs);
    }

    @Generated
    public List<PersonAttributeDao> getPersonAttributeDaos() {
        return this.personAttributeDaos;
    }

    @Generated
    public AttributeMerger getAttributeMerger() {
        return this.attributeMerger;
    }

    @Generated
    public boolean isRecoverExceptions() {
        return this.recoverExceptions;
    }

    @Generated
    public boolean isStopOnSuccess() {
        return this.stopOnSuccess;
    }

    @Generated
    public boolean isRequireAll() {
        return this.requireAll;
    }

    @Generated
    public void setPersonAttributeDaos(List<PersonAttributeDao> personAttributeDaos) {
        this.personAttributeDaos = personAttributeDaos;
    }

    @Generated
    public void setAttributeMerger(AttributeMerger attributeMerger) {
        this.attributeMerger = attributeMerger;
    }

    @Generated
    public void setRecoverExceptions(boolean recoverExceptions) {
        this.recoverExceptions = recoverExceptions;
    }

    @Generated
    public void setStopOnSuccess(boolean stopOnSuccess) {
        this.stopOnSuccess = stopOnSuccess;
    }

    @Generated
    public void setRequireAll(boolean requireAll) {
        this.requireAll = requireAll;
    }
}

