/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class JPARealmDAO
implements RealmDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDAO.class);
    protected final RoleDAO roleDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final ApplicationEventPublisher publisher;
    protected final EntityManager entityManager;

    public JPARealmDAO(RoleDAO roleDAO, RealmSearchDAO realmSearchDAO, PlainSchemaDAO plainSchemaDAO, ApplicationEventPublisher publisher, EntityManager entityManager) {
        this.roleDAO = roleDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.publisher = publisher;
        this.entityManager = entityManager;
    }

    public Realm getRoot() {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e.parent IS NULL", Realm.class);
        Realm result = null;
        try {
            result = (Realm)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("Root realm not found", (Throwable)e);
        }
        return result;
    }

    public boolean existsById(String key) {
        return this.findById(key).isPresent();
    }

    @Transactional(readOnly=true)
    public Optional<? extends Realm> findById(String key) {
        return Optional.ofNullable((JPARealm)this.entityManager.find(JPARealm.class, (Object)key));
    }

    protected <T extends Policy> List<Realm> findSamePolicyChildren(Realm realm, T policy) {
        ArrayList<Realm> result = new ArrayList<Realm>();
        this.realmSearchDAO.findChildren(realm).stream().filter(child -> policy instanceof AccountPolicy && child.getAccountPolicy() == null || policy.equals((Object)child.getAccountPolicy()) || policy instanceof PasswordPolicy && child.getPasswordPolicy() == null || policy.equals((Object)child.getPasswordPolicy())).forEach(child -> {
            result.add((Realm)child);
            result.addAll(this.findSamePolicyChildren((Realm)child, policy));
        });
        return result;
    }

    public <T extends Policy> List<Realm> findByPolicy(T policy) {
        if (policy instanceof PropagationPolicy || policy instanceof ProvisioningPolicy) {
            return List.of();
        }
        String policyColumn = null;
        if (policy instanceof AccountPolicy) {
            policyColumn = "accountPolicy";
        } else if (policy instanceof PasswordPolicy) {
            policyColumn = "passwordPolicy";
        } else if (policy instanceof AuthPolicy) {
            policyColumn = "authPolicy";
        } else if (policy instanceof AccessPolicy) {
            policyColumn = "accessPolicy";
        } else if (policy instanceof AttrReleasePolicy) {
            policyColumn = "attrReleasePolicy";
        } else if (policy instanceof TicketExpirationPolicy) {
            policyColumn = "ticketExpirationPolicy";
        }
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE e." + policyColumn + "=:policy", Realm.class);
        query.setParameter("policy", policy);
        ArrayList<Realm> result = new ArrayList<Realm>();
        query.getResultList().forEach(realm -> {
            result.add((Realm)realm);
            result.addAll(this.findSamePolicyChildren((Realm)realm, policy));
        });
        return result;
    }

    public List<Realm> findByActionsContaining(Implementation logicActions) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE :logicActions MEMBER OF e.actions", Realm.class);
        query.setParameter("logicActions", (Object)logicActions);
        return query.getResultList();
    }

    public List<Realm> findByResources(ExternalResource resource) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e WHERE :resource MEMBER OF e.resources", Realm.class);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public long count() {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM Realm");
        return ((Number)query.getSingleResult()).longValue();
    }

    public List<? extends Realm> findAll() {
        throw new UnsupportedOperationException();
    }

    public Page<? extends Realm> findAll(Pageable pageable) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPARealm.class.getSimpleName() + " e ORDER BY e.fullPath", Realm.class);
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        return new SyncopePage(query.getResultList(), pageable, this.count());
    }

    public <S extends Realm> S save(S realm) {
        String fullPathAfter;
        new ArrayList<PlainAttr>(((JPARealm)realm).getPlainAttrsList()).stream().filter(attr -> attr.getUniqueValue() != null).forEach(attr -> {
            if (this.plainSchemaDAO.existsPlainAttrUniqueValue(realm.getKey(), (PlainSchema)this.plainSchemaDAO.findById(attr.getSchema()).orElseThrow(() -> new NotFoundException("PlainSchema " + attr.getSchema())), attr.getUniqueValue())) {
                throw new DuplicateException("Duplicate value found for " + attr.getSchema() + "=" + attr.getUniqueValue().getValueAsString());
            }
            LOG.debug("No duplicate value found for {}={}", (Object)attr.getSchema(), (Object)attr.getUniqueValue().getValueAsString());
        });
        String fullPathBefore = realm.getFullPath();
        String string = fullPathAfter = realm.getParent() == null ? "/" : Strings.CS.appendIfMissing(realm.getParent().getFullPath(), (CharSequence)"/", new CharSequence[0]) + realm.getName();
        if (!fullPathAfter.equals(fullPathBefore)) {
            ((JPARealm)realm).setFullPath(fullPathAfter);
        }
        Realm merged = (Realm)this.entityManager.merge(realm);
        this.entityManager.flush();
        if (!fullPathAfter.equals(fullPathBefore)) {
            this.realmSearchDAO.findChildren(realm).forEach(this::save);
        }
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)merged, AuthContextUtils.getDomain()));
        return (S)merged;
    }

    public void deleteById(String key) {
        this.findById(key).ifPresent(this::delete);
    }

    public void delete(Realm realm) {
        if (realm == null || realm.getParent() == null) {
            return;
        }
        this.realmSearchDAO.findDescendants(realm.getFullPath(), null, Pageable.unpaged()).forEach(toBeDeleted -> {
            this.roleDAO.findByRealms(toBeDeleted).forEach(role -> role.getRealms().remove(toBeDeleted));
            toBeDeleted.setParent(null);
            this.entityManager.remove(toBeDeleted);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Entity)toBeDeleted, AuthContextUtils.getDomain()));
        });
    }
}

