/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.common.engine.impl.variable.NoopVariableLengthVerifier;
import org.flowable.common.engine.impl.variable.VariableLengthVerifier;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class StringType
implements VariableType {
    public static final String TYPE_NAME = "string";
    private final int maxLength;
    private final VariableLengthVerifier lengthVerifier;

    public StringType(int maxLength) {
        this(maxLength, NoopVariableLengthVerifier.INSTANCE);
    }

    public StringType(int maxLength, VariableLengthVerifier lengthVerifier) {
        this.maxLength = maxLength;
        this.lengthVerifier = lengthVerifier;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        return valueFields.getTextValue();
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value == null) {
            valueFields.setTextValue(null);
        } else {
            String textValue = (String)value;
            this.lengthVerifier.verifyLength(textValue.length(), valueFields, (VariableType)this);
            valueFields.setTextValue(textValue);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringValue = (String)value;
            return stringValue.length() <= this.maxLength;
        }
        return false;
    }
}

