/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.attribute.BasePersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.springframework.http.HttpMethod;

public class RestfulPersonAttributeDao
extends BasePersonAttributeDao {
    private final ObjectMapper jacksonObjectMapper = new ObjectMapper().findAndRegisterModules();
    private UsernameAttributeProvider usernameAttributeProvider = new SimpleUsernameAttributeProvider();
    private String url;
    private String basicAuthUsername;
    private String basicAuthPassword;
    private String method;
    private String principalId = "username";
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    public PersonAttributes getPerson(String uid, Set<PersonAttributes> resultPeople, PersonAttributeDaoFilter filter) {
        try {
            if (!this.isEnabled()) {
                return null;
            }
            HttpClientBuilder builder = HttpClientBuilder.create();
            URIBuilder uriBuilder = new URIBuilder(this.url);
            if (StringUtils.isNotBlank((CharSequence)this.basicAuthUsername) && StringUtils.isNotBlank((CharSequence)this.basicAuthPassword)) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.basicAuthUsername, this.basicAuthPassword.toCharArray());
                provider.setCredentials(new AuthScope(new HttpHost(uriBuilder.getHost())), (Credentials)credentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
            CloseableHttpClient client = builder.build();
            uriBuilder.addParameter(this.principalId, Objects.requireNonNull(uid, () -> this.principalId + " cannot be null"));
            this.parameters.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
            URI uri = uriBuilder.build();
            HttpGet request = this.method.equalsIgnoreCase(HttpMethod.GET.name()) ? new HttpGet(uri) : new HttpPost(uri);
            this.headers.forEach((arg_0, arg_1) -> ((HttpUriRequestBase)request).addHeader(arg_0, arg_1));
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)request);
            Map attributes = (Map)this.jacksonObjectMapper.readValue(response.getEntity().getContent(), Map.class);
            return new SimplePersonAttributes(uid, PersonAttributeDao.stuffAttributesIntoList((Map)attributes));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Set<PersonAttributes> getPeople(Map<String, Object> query, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        Map queryAttributes = PersonAttributeDao.stuffAttributesIntoList(query);
        return this.getPeopleWithMultivaluedAttributes(queryAttributes, filter, resultPeople);
    }

    public Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        LinkedHashSet<PersonAttributes> people = new LinkedHashSet<PersonAttributes>();
        String username = this.usernameAttributeProvider.getUsernameFromQuery(query);
        PersonAttributes person = this.getPerson(username, resultPeople, filter);
        if (person != null) {
            people.add(person);
        }
        return people;
    }

    @Generated
    public ObjectMapper getJacksonObjectMapper() {
        return this.jacksonObjectMapper;
    }

    @Generated
    public UsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    @Generated
    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getPrincipalId() {
        return this.principalId;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setUsernameAttributeProvider(UsernameAttributeProvider usernameAttributeProvider) {
        this.usernameAttributeProvider = usernameAttributeProvider;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setBasicAuthUsername(String basicAuthUsername) {
        this.basicAuthUsername = basicAuthUsername;
    }

    @Generated
    public void setBasicAuthPassword(String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

