/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.stream.Stream;

public final class StringUtil {
    public static final String EMPTY = "";
    private static final String END_XMLCOMMENT = "-->";
    private static final String START_XMLCOMMENT = "<!--";
    private static final String VAR_REG_EX_START = "\\$\\{";
    private static final String VAR_REG_EX_END = "\\}";

    private StringUtil() {
        throw new AssertionError();
    }

    public static int indexOfDigit(String str, int startidx) {
        int ret = -1;
        if (str != null) {
            for (int i = startidx; i < str.length(); ++i) {
                if (!Character.isDigit(str.charAt(i))) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    public static int indexOfDigit(String str) {
        return StringUtil.indexOfDigit(str, 0);
    }

    public static int indexOfNonDigit(String str, int startidx) {
        int ret = -1;
        if (str != null) {
            for (int i = startidx; i < str.length(); ++i) {
                if (Character.isDigit(str.charAt(i))) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    public static int indexOfNonDigit(String str) {
        return StringUtil.indexOfNonDigit(str, 0);
    }

    public static String subDigitString(String str) {
        return StringUtil.subDigitString(str, 0);
    }

    public static String subDigitString(String str, int idx) {
        String ret = null;
        int sidx = StringUtil.indexOfDigit(str, idx);
        if (sidx != -1) {
            int eidx = StringUtil.indexOfNonDigit(str, sidx);
            ret = eidx == -1 ? str.substring(sidx) : str.substring(sidx, eidx);
        }
        return ret;
    }

    public static String stripXmlAttribute(String src, String attrName) {
        int closeQuote;
        int openQuote;
        int start;
        String ret = null;
        if (src == null) {
            return null;
        }
        char[] quote = new char[]{'\'', '\"'};
        ret = src;
        while ((start = ret.indexOf(attrName)) != -1 && (openQuote = StringUtil.indexOf(ret, quote, start)) != -1 && (closeQuote = StringUtil.indexOf(ret, quote, openQuote + 1)) != -1) {
            if (start - 1 >= 0 && ret.charAt(start - 1) == ' ') {
                --start;
            } else if (closeQuote + 1 < ret.length() && ret.charAt(closeQuote + 1) == ' ') {
                ++closeQuote;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(ret.substring(0, start));
            builder.append(ret.substring(closeQuote + 1));
            ret = builder.toString();
        }
        return ret;
    }

    public static String stripNewlines(String src) {
        String dest = null;
        if (src != null) {
            StringBuilder b = new StringBuilder();
            int max = src.length();
            for (int i = 0; i < max; ++i) {
                char c = src.charAt(i);
                if (c == '\n' || c == '\r') continue;
                b.append(c);
            }
            dest = b.toString();
        }
        return dest;
    }

    public static int indexOfIgnoreCase(String src, String cmp) {
        if (src == null || cmp == null) {
            return -1;
        }
        String isrc = src.toUpperCase();
        String icmp = cmp.toUpperCase();
        return isrc.indexOf(icmp);
    }

    public static String stripXmlComments(String src) {
        int end;
        int start;
        if (src == null) {
            return null;
        }
        String ret = src;
        while ((start = ret.indexOf(START_XMLCOMMENT)) != -1 && (end = ret.indexOf(END_XMLCOMMENT, start)) != -1) {
            StringBuilder builder = new StringBuilder();
            builder.append(ret.substring(0, start));
            builder.append(ret.substring(end + END_XMLCOMMENT.length()));
            ret = builder.toString();
        }
        return ret;
    }

    public static int indexOf(String src, char[] ch) {
        return StringUtil.indexOf(src, ch, 0);
    }

    public static int indexOf(String src, char[] ch, int idx) {
        int ret = Integer.MAX_VALUE;
        for (int i = 0; i < ch.length; ++i) {
            int tmp = src.indexOf(ch[i], idx);
            if (tmp == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static boolean isEmpty(String val) {
        return val == null ? true : EMPTY.equals(val);
    }

    public static boolean isNotEmpty(String val) {
        return !StringUtil.isEmpty(val);
    }

    public static boolean isBlank(String val) {
        return val == null ? true : StringUtil.isEmpty(val.trim());
    }

    public static boolean isNotBlank(String val) {
        return !StringUtil.isBlank(val);
    }

    public static Properties toProperties(String value) {
        Properties ret = new Properties();
        if (StringUtil.isNotBlank(value)) {
            try {
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                ret.load(new ByteArrayInputStream(bytes));
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return ret;
    }

    public static String replaceVariable(String o, String var, String val) {
        try {
            if (o == null || StringUtil.isBlank(var) || val == null) {
                throw new IllegalArgumentException();
            }
            String regex = VAR_REG_EX_START + var + VAR_REG_EX_END;
            String value = Matcher.quoteReplacement(val);
            return o.replaceAll(regex, value);
        }
        catch (RuntimeException e) {
            StringBuilder bld = new StringBuilder();
            bld.append(" var: ").append(var);
            bld.append(" val: ").append(val);
            bld.append(" o: ").append(o);
            throw new IllegalArgumentException(bld.toString());
        }
    }

    public static boolean endsWith(String str, char value) {
        return StringUtil.isBlank(str) ? false : str.charAt(str.length() - 1) == value;
    }

    public static List<String> parseLine(String line, char fsep, char tqul) {
        String f;
        assert (StringUtil.isNotBlank(line));
        ArrayList<String> fields = new ArrayList<String>();
        int length = StringUtil.endsWith(line, fsep) ? line.length() - 1 : line.length();
        int whitespace = 0;
        boolean inQuotes = false;
        boolean fieldStarted = false;
        boolean fieldFinished = false;
        StringBuilder field = new StringBuilder();
        for (int j = 0; j < length; ++j) {
            char ch = line.charAt(j);
            if (StringUtil.isWhitespace(ch)) {
                if (fieldStarted) {
                    ++whitespace;
                    field.append(ch);
                }
            } else {
                fieldStarted = true;
                if (ch == tqul) {
                    whitespace = 0;
                    if (inQuotes) {
                        if (j + 1 < length) {
                            char nextCh = line.charAt(j + 1);
                            if (nextCh == tqul) {
                                field.append(ch);
                                ++j;
                            } else {
                                inQuotes = false;
                            }
                        } else {
                            inQuotes = false;
                        }
                    } else {
                        inQuotes = true;
                    }
                } else if (ch == fsep) {
                    if (inQuotes) {
                        whitespace = 0;
                        field.append(ch);
                    } else {
                        fieldFinished = true;
                    }
                } else {
                    whitespace = 0;
                    field.append(ch);
                }
            }
            if (!fieldFinished) continue;
            f = field.toString();
            if (whitespace > 0) {
                f = f.substring(0, f.length() - whitespace);
            }
            fields.add(f);
            field.setLength(0);
            whitespace = 0;
            fieldStarted = false;
            fieldFinished = false;
        }
        if (inQuotes) {
            fields = null;
            throw new IllegalStateException("Unterminated quotation mark detected.");
        }
        f = field.toString();
        if (whitespace > 0) {
            f = f.substring(0, f.length() - whitespace);
        }
        fields.add(f);
        return fields;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    public static String randomString() {
        return StringUtil.randomString(new Random());
    }

    public static String randomString(Random r) {
        return StringUtil.randomString(r, Math.abs(r.nextInt(257)));
    }

    public static String randomString(Random r, int length) {
        StringBuilder bld = new StringBuilder(length);
        while (bld.length() < length) {
            int rnd = r.nextInt() & 0xFFFF;
            if (!Character.isLetter(rnd)) continue;
            bld.append((char)rnd);
        }
        return bld.toString();
    }

    public static String join(Collection<String> collection, char separator) {
        if (collection == null) {
            return null;
        }
        return StringUtil.join(collection.toArray(new String[collection.size()]), separator, 0, collection.size());
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtil.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int noOfItems = endIndex - startIndex;
        if (noOfItems <= 0) {
            return EMPTY;
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static boolean allNotNull(Object ... values) {
        return values != null && Stream.of(values).noneMatch(Objects::isNull);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (!StringUtil.allNotNull(str, open, close)) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }
}

