/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.wicket.model.Model;

public final class Action<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -7989237020377623993L;
    private final List<String> realms = new ArrayList<String>();
    private final ActionLink<T> link;
    private final ActionLink.ActionType type;
    private String entitlements;
    private boolean onConfirm;
    private boolean visibleLabel;
    private Model<String> label;
    private Model<String> title;
    private Model<String> alt;
    private Model<String> icon;
    private boolean indicator;

    public Action(ActionLink<T> link, ActionLink.ActionType type) {
        this.link = link;
        this.type = type;
        this.entitlements = "";
        this.onConfirm = false;
        this.visibleLabel = true;
        this.label = null;
        this.title = null;
        this.alt = null;
        this.icon = null;
        this.indicator = true;
    }

    public String[] getRealms() {
        return (String[])this.realms.toArray(String[]::new);
    }

    public void setRealm(String realm) {
        this.realms.clear();
        if (realm != null) {
            this.realms.add(realm);
        }
    }

    public void setRealms(String realm, List<String> dynRealms) {
        this.setRealm(realm);
        if (dynRealms != null) {
            this.realms.addAll(dynRealms);
        }
    }

    public ActionLink<T> getLink() {
        return this.link;
    }

    public ActionLink.ActionType getType() {
        return this.type;
    }

    public String getEntitlements() {
        return this.entitlements;
    }

    public boolean isOnConfirm() {
        return this.onConfirm;
    }

    public Action<T> setEntitlements(String entitlements) {
        this.entitlements = entitlements;
        return this;
    }

    public Action<T> setOnConfirm(boolean onConfirm) {
        this.onConfirm = onConfirm;
        return this;
    }

    public Action<T> hideLabel() {
        this.visibleLabel = false;
        return this;
    }

    public Action<T> showLabel() {
        this.visibleLabel = true;
        return this;
    }

    public boolean isVisibleLabel() {
        return this.visibleLabel;
    }

    public Action<T> setLabel(Model<String> label) {
        this.label = label;
        return this;
    }

    public Model<String> getLabel() {
        return this.label;
    }

    public Action<T> setTitleI(Model<String> title) {
        this.title = title;
        return this;
    }

    public Model<String> getTitle() {
        return this.title;
    }

    public Action<T> setAlt(Model<String> alt) {
        this.alt = alt;
        return this;
    }

    public Model<String> getAlt() {
        return this.alt;
    }

    public Action<T> setIcon(Model<String> icon) {
        this.icon = icon;
        return this;
    }

    public Model<String> getIcon() {
        return this.icon;
    }

    public Action<T> disableIndicator() {
        this.indicator = false;
        return this;
    }

    public boolean hasIndicator() {
        return this.indicator;
    }
}

