/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableAnyProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyDataProvider<A extends AnyTO>
extends DirectoryDataProvider<A> {
    private static final long serialVersionUID = 6267494272884913376L;
    protected static final Logger LOG = LoggerFactory.getLogger(AnyDataProvider.class);
    protected final SortableAnyProviderComparator<A> comparator;
    protected final AbstractAnyRestClient<A> restClient;
    protected String fiql;
    protected final boolean filtered;
    protected final String realm;
    protected final PageReference pageRef;
    protected int currentPage;

    public AnyDataProvider(AbstractAnyRestClient<A> restClient, int paginatorRows, boolean filtered, String realm, String type, PageReference pageRef) {
        super(paginatorRows);
        this.restClient = restClient;
        this.filtered = filtered;
        switch (type) {
            case "USER": {
                this.setSort("username", SortOrder.ASCENDING);
                break;
            }
            case "GROUP": {
                this.setSort("name", SortOrder.ASCENDING);
                break;
            }
        }
        this.comparator = new SortableAnyProviderComparator(this);
        this.realm = realm;
        this.pageRef = pageRef;
    }

    public Iterator<A> iterator(long first, long count) {
        List<Object> result = new ArrayList();
        try {
            this.currentPage = (int)first / this.paginatorRows;
            if (this.currentPage < 0) {
                this.currentPage = 0;
            }
            result = this.filtered ? Optional.ofNullable(this.fiql).map(s -> this.restClient.search(this.realm, (String)s, this.currentPage + 1, this.paginatorRows, (SortParam<String>)this.getSort())).orElseGet(List::of) : this.restClient.search(this.realm, null, this.currentPage + 1, this.paginatorRows, (SortParam<String>)this.getSort());
        }
        catch (Exception e) {
            LOG.error("While searching with FIQL {}", (Object)this.fiql, (Object)e);
            SyncopeConsoleSession.get().onException(e);
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(target -> ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target));
        }
        return result.iterator();
    }

    public long size() {
        long result = 0L;
        try {
            result = this.filtered ? Optional.ofNullable(this.fiql).map(s -> this.restClient.count(this.realm, (String)s)).orElse(0L).longValue() : this.restClient.count(this.realm, null);
        }
        catch (Exception e) {
            LOG.error("While requesting for size() with FIQL {}", (Object)this.fiql, (Object)e);
            SyncopeConsoleSession.get().onException(e);
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(target -> ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target));
        }
        return result;
    }

    public AnyDataProvider<A> setFIQL(String fiql) {
        this.fiql = fiql;
        return this;
    }

    public IModel<A> model(A object) {
        return new CompoundPropertyModel(object);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }
}

