/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageLoadContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.slf4j.Logger;

public class PopulateClientStorageLoadContext
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String LOAD_NOT_NEEDED = "NoLoadNeeded";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateClientStorageLoadContext.class);
    @Nonnull
    private Collection<ClientStorageService> storageServices = CollectionSupport.emptyList();

    public void setStorageServices(@Nullable Collection<ClientStorageService> services) {
        this.checkSetterPreconditions();
        this.storageServices = services != null ? CollectionSupport.copyToList(services) : CollectionSupport.emptyList();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)LOAD_NOT_NEEDED);
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)LOAD_NOT_NEEDED);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClientStorageLoadContext loadCtx = new ClientStorageLoadContext();
        ArrayList<String> ids = new ArrayList<String>();
        for (ClientStorageService service : this.storageServices) {
            try {
                if (service.isLoaded()) continue;
                loadCtx.getStorageKeys().add(service.getStorageName());
                ids.add(service.ensureId());
            }
            catch (IOException e) {
                this.log.warn("{} Error checking load status of {}, assuming unloaded", (Object)this.getLogPrefix(), (Object)service.getId());
                loadCtx.getStorageKeys().add(service.getStorageName());
                ids.add(service.ensureId());
            }
        }
        if (loadCtx.getStorageKeys().isEmpty()) {
            this.log.debug("{} No ClientStorageServices require loading, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)LOAD_NOT_NEEDED);
        } else {
            this.log.debug("{} ClientStorageServices requiring load: {}", (Object)this.getLogPrefix(), ids);
            profileRequestContext.addSubcontext((BaseContext)loadCtx, true);
        }
    }
}

