/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.crypto;

import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

@Deprecated
public class BouncyCastleCrypto
implements Crypto {
    private static final Provider provider = new BouncyCastleProvider();

    public Provider getProvider() {
        return provider;
    }

    @Override
    public void checkSignature(X509Certificate attestationCertificate, byte[] signedBytes, byte[] signature) throws U2fBadInputException {
        this.checkSignature(attestationCertificate.getPublicKey(), signedBytes, signature);
    }

    @Override
    public void checkSignature(PublicKey publicKey, byte[] signedBytes, byte[] signature) throws U2fBadInputException {
        try {
            Signature ecdsaSignature = Signature.getInstance("SHA256withECDSA", provider);
            ecdsaSignature.initVerify(publicKey);
            ecdsaSignature.update(signedBytes);
            if (!ecdsaSignature.verify(signature)) {
                throw new U2fBadInputException(String.format("Signature is invalid. Public key: %s, signed data: %s , signature: %s", publicKey, U2fB64Encoding.encode(signedBytes), U2fB64Encoding.encode(signature)));
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(String.format("Failed to verify signature. This could be a problem with your JVM environment, or a bug in u2flib-server-core. Public key: %s, signed data: %s , signature: %s", publicKey, U2fB64Encoding.encode(signedBytes), U2fB64Encoding.encode(signature)), e);
        }
    }

    @Override
    public PublicKey decodePublicKey(byte[] encodedPublicKey) throws U2fBadInputException {
        try {
            ECPoint point;
            X9ECParameters curve = SECNamedCurves.getByName((String)"secp256r1");
            try {
                point = curve.getCurve().decodePoint(encodedPublicKey);
            }
            catch (RuntimeException e) {
                throw new U2fBadInputException("Could not parse user public key", e);
            }
            return KeyFactory.getInstance("ECDSA", provider).generatePublic((KeySpec)new ECPublicKeySpec(point, new ECParameterSpec(curve.getCurve(), curve.getG(), curve.getN(), curve.getH())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Failed to decode public key: " + U2fB64Encoding.encode(encodedPublicKey), e);
        }
    }

    @Override
    public byte[] hash(byte[] bytes) {
        try {
            return MessageDigest.getInstance("SHA-256", provider).digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] hash(String str) {
        return this.hash(str.getBytes());
    }
}

