/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.table.security;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.tirasa.connid.bundles.db.table.security.EncodeAlgorithm;
import net.tirasa.connid.bundles.db.table.security.PasswordDecodingException;
import net.tirasa.connid.bundles.db.table.security.PasswordEncodingException;

public class AES
extends EncodeAlgorithm {
    private static final String NAME = "AES";
    private SecretKeySpec keySpec = null;

    @Override
    public String encode(String clearPwd, String charsetName) throws PasswordEncodingException {
        if (this.keySpec == null) {
            throw new PasswordEncodingException("Invalid secret key.");
        }
        if (charsetName == null) {
            throw new PasswordEncodingException("Invalid password charset.");
        }
        try {
            byte[] cleartext = clearPwd.getBytes(Charset.forName(charsetName));
            Cipher cipher = Cipher.getInstance(this.getName());
            cipher.init(1, this.keySpec);
            return Base64.getEncoder().encodeToString(cipher.doFinal(cleartext));
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error encoding password", new Object[0]);
            throw new PasswordEncodingException(e.getMessage());
        }
    }

    @Override
    public String decode(String encodedPwd, String charsetName) throws PasswordDecodingException {
        if (this.keySpec == null) {
            throw new PasswordDecodingException("Invalid secret key");
        }
        if (charsetName == null) {
            throw new PasswordDecodingException("Invalid password charset.");
        }
        try {
            byte[] encoded = Base64.getDecoder().decode(encodedPwd);
            Cipher cipher = Cipher.getInstance(this.getName());
            cipher.init(2, this.keySpec);
            return new String(cipher.doFinal(encoded), Charset.forName(charsetName));
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error decoding password", new Object[0]);
            throw new PasswordDecodingException(e.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setKey(String key) throws UnsupportedEncodingException {
        this.keySpec = new SecretKeySpec(Arrays.copyOfRange(key.getBytes(StandardCharsets.UTF_8), 0, 16), this.getName());
    }
}

