/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.terracotta.connection.ConnectionException;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionFactory;

public abstract class ConnectionSource {
    public abstract String getClusterTierManager();

    public abstract LeasedConnection connect(Properties var1) throws ConnectionException;

    public abstract URI getClusterUri();

    public static class ServerList
    extends ConnectionSource {
        private final Iterable<InetSocketAddress> servers;
        private final String clusterTierManager;

        public ServerList(Iterable<InetSocketAddress> servers, String clusterTierManager) {
            this.servers = this.cloneServers(Objects.requireNonNull(servers, "Servers cannot be null"));
            this.clusterTierManager = Objects.requireNonNull(clusterTierManager, "Cluster tier manager identifier cannot be null");
        }

        @Override
        public String getClusterTierManager() {
            return this.clusterTierManager;
        }

        @Override
        public LeasedConnection connect(Properties connectionProperties) throws ConnectionException {
            return LeasedConnectionFactory.connect(this.servers, (Properties)connectionProperties);
        }

        @Override
        public URI getClusterUri() {
            throw new IllegalStateException("Cannot use getClusterUri() on ConnectionSource.ServerList. Use getServers() instead.");
        }

        public Iterable<InetSocketAddress> getServers() {
            return this.cloneServers(this.servers);
        }

        public String toString() {
            return "servers: " + this.getServers() + " [cache-manager: " + this.getClusterTierManager() + "]";
        }

        private List<InetSocketAddress> cloneServers(Iterable<InetSocketAddress> servers) {
            ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>();
            servers.forEach(socketAddresses::add);
            return socketAddresses;
        }
    }

    public static class ClusterUri
    extends ConnectionSource {
        private final URI clusterUri;
        private final String clusterTierManager;

        public ClusterUri(URI clusterUri) {
            this.clusterUri = Objects.requireNonNull(clusterUri, "Cluster URI cannot be null");
            this.clusterTierManager = ClusterUri.extractCacheManager(clusterUri);
        }

        @Override
        public String getClusterTierManager() {
            return this.clusterTierManager;
        }

        @Override
        public LeasedConnection connect(Properties connectionProperties) throws ConnectionException {
            return LeasedConnectionFactory.connect((URI)ClusterUri.extractClusterUri(this.clusterUri), (Properties)connectionProperties);
        }

        @Override
        public URI getClusterUri() {
            return this.clusterUri;
        }

        public String toString() {
            return "clusterUri: " + this.clusterUri;
        }

        private static String extractCacheManager(URI uri) {
            URI baseUri = ClusterUri.extractClusterUri(uri);
            return baseUri.relativize(uri).getPath();
        }

        private static URI extractClusterUri(URI uri) {
            try {
                return new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

