/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.OIDCApplicationType;
import org.apache.syncope.common.lib.types.OIDCClientAuthenticationMethod;
import org.apache.syncope.common.lib.types.OIDCGrantType;
import org.apache.syncope.common.lib.types.OIDCResponseType;
import org.apache.syncope.common.lib.types.OIDCSubjectType;
import org.apache.syncope.common.lib.types.OIDCTokenEncryptionAlg;
import org.apache.syncope.common.lib.types.OIDCTokenEncryptionEncoding;
import org.apache.syncope.common.lib.types.OIDCTokenSigningAlg;

@Schema(allOf={ClientAppTO.class})
public class OIDCRPClientAppTO
extends ClientAppTO {
    private static final long serialVersionUID = -6370888503924521351L;
    private String clientId;
    private String clientSecret;
    private String idTokenIssuer;
    private boolean signIdToken = true;
    private OIDCTokenSigningAlg idTokenSigningAlg = OIDCTokenSigningAlg.none;
    private boolean encryptIdToken;
    private OIDCTokenEncryptionAlg idTokenEncryptionAlg = OIDCTokenEncryptionAlg.none;
    private OIDCTokenEncryptionEncoding idTokenEncryptionEncoding;
    private OIDCTokenSigningAlg userInfoSigningAlg;
    private OIDCTokenEncryptionAlg userInfoEncryptedResponseAlg;
    private OIDCTokenEncryptionEncoding userInfoEncryptedResponseEncoding;
    private boolean jwtAccessToken;
    private boolean bypassApprovalPrompt = true;
    private boolean generateRefreshToken = true;
    private OIDCSubjectType subjectType = OIDCSubjectType.PUBLIC;
    private OIDCApplicationType applicationType = OIDCApplicationType.WEB;
    private final List<String> redirectUris = new ArrayList<String>();
    private final List<OIDCGrantType> supportedGrantTypes = new ArrayList<OIDCGrantType>();
    private final List<OIDCResponseType> supportedResponseTypes = new ArrayList<OIDCResponseType>();
    private final List<String> scopes = new ArrayList<String>();
    private String jwks;
    private String jwksUri;
    private OIDCClientAuthenticationMethod tokenEndpointAuthenticationMethod = OIDCClientAuthenticationMethod.client_secret_basic;
    private String logoutUri;

    @Override
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.to.client.OIDCRPTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @JacksonXmlElementWrapper(localName="redirectUris")
    @JacksonXmlProperty(localName="redirectUri")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JacksonXmlElementWrapper(localName="supportedGrantTypes")
    @JacksonXmlProperty(localName="supportedGrantType")
    public List<OIDCGrantType> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    @JacksonXmlElementWrapper(localName="supportedResponseTypes")
    @JacksonXmlProperty(localName="supportedResponseType")
    public List<OIDCResponseType> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    public String getIdTokenIssuer() {
        return this.idTokenIssuer;
    }

    public void setIdTokenIssuer(String idTokenIssuer) {
        this.idTokenIssuer = idTokenIssuer;
    }

    public boolean isSignIdToken() {
        return this.signIdToken;
    }

    public void setSignIdToken(boolean signIdToken) {
        this.signIdToken = signIdToken;
    }

    public boolean isEncryptIdToken() {
        return this.encryptIdToken;
    }

    public void setEncryptIdToken(boolean encryptIdToken) {
        this.encryptIdToken = encryptIdToken;
    }

    public OIDCTokenSigningAlg getIdTokenSigningAlg() {
        return this.idTokenSigningAlg;
    }

    public void setIdTokenSigningAlg(OIDCTokenSigningAlg idTokenSigningAlg) {
        this.idTokenSigningAlg = idTokenSigningAlg;
    }

    public OIDCTokenEncryptionAlg getIdTokenEncryptionAlg() {
        return this.idTokenEncryptionAlg;
    }

    public void setIdTokenEncryptionAlg(OIDCTokenEncryptionAlg idTokenEncryptionAlg) {
        this.idTokenEncryptionAlg = idTokenEncryptionAlg;
    }

    public OIDCTokenEncryptionEncoding getIdTokenEncryptionEncoding() {
        return this.idTokenEncryptionEncoding;
    }

    public void setIdTokenEncryptionEncoding(OIDCTokenEncryptionEncoding idTokenEncryptionEncoding) {
        this.idTokenEncryptionEncoding = idTokenEncryptionEncoding;
    }

    public OIDCTokenSigningAlg getUserInfoSigningAlg() {
        return this.userInfoSigningAlg;
    }

    public void setUserInfoSigningAlg(OIDCTokenSigningAlg userInfoSigningAlg) {
        this.userInfoSigningAlg = userInfoSigningAlg;
    }

    public OIDCTokenEncryptionAlg getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(OIDCTokenEncryptionAlg userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public OIDCTokenEncryptionEncoding getUserInfoEncryptedResponseEncoding() {
        return this.userInfoEncryptedResponseEncoding;
    }

    public void setUserInfoEncryptedResponseEncoding(OIDCTokenEncryptionEncoding encoding) {
        this.userInfoEncryptedResponseEncoding = encoding;
    }

    public OIDCSubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(OIDCSubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public OIDCApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(OIDCApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public boolean isJwtAccessToken() {
        return this.jwtAccessToken;
    }

    public void setJwtAccessToken(boolean jwtAccessToken) {
        this.jwtAccessToken = jwtAccessToken;
    }

    @JacksonXmlElementWrapper(localName="scopes")
    @JacksonXmlProperty(localName="scope")
    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean isBypassApprovalPrompt() {
        return this.bypassApprovalPrompt;
    }

    public void setBypassApprovalPrompt(boolean bypassApprovalPrompt) {
        this.bypassApprovalPrompt = bypassApprovalPrompt;
    }

    public boolean isGenerateRefreshToken() {
        return this.generateRefreshToken;
    }

    public void setGenerateRefreshToken(boolean generateRefreshToken) {
        this.generateRefreshToken = generateRefreshToken;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public OIDCClientAuthenticationMethod getTokenEndpointAuthenticationMethod() {
        return this.tokenEndpointAuthenticationMethod;
    }

    public void setTokenEndpointAuthenticationMethod(OIDCClientAuthenticationMethod tokenEndpointAuthenticationMethod) {
        this.tokenEndpointAuthenticationMethod = tokenEndpointAuthenticationMethod;
    }

    public String getLogoutUri() {
        return this.logoutUri;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OIDCRPClientAppTO rhs = (OIDCRPClientAppTO)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.clientId, (Object)rhs.clientId).append((Object)this.clientSecret, (Object)rhs.clientSecret).append((Object)this.idTokenIssuer, (Object)rhs.idTokenIssuer).append(this.signIdToken, rhs.signIdToken).append((Object)this.idTokenSigningAlg, (Object)rhs.idTokenSigningAlg).append(this.encryptIdToken, rhs.encryptIdToken).append((Object)this.idTokenEncryptionAlg, (Object)rhs.idTokenEncryptionAlg).append((Object)this.idTokenEncryptionEncoding, (Object)rhs.idTokenEncryptionEncoding).append((Object)this.userInfoSigningAlg, (Object)rhs.userInfoSigningAlg).append((Object)this.userInfoEncryptedResponseAlg, (Object)rhs.userInfoEncryptedResponseAlg).append((Object)this.userInfoEncryptedResponseEncoding, (Object)rhs.userInfoEncryptedResponseEncoding).append(this.jwtAccessToken, rhs.jwtAccessToken).append(this.bypassApprovalPrompt, rhs.bypassApprovalPrompt).append(this.generateRefreshToken, rhs.generateRefreshToken).append((Object)this.subjectType, (Object)rhs.subjectType).append((Object)this.applicationType, (Object)rhs.applicationType).append(this.redirectUris, rhs.redirectUris).append(this.supportedGrantTypes, rhs.supportedGrantTypes).append(this.supportedResponseTypes, rhs.supportedResponseTypes).append(this.scopes, rhs.scopes).append((Object)this.jwks, (Object)rhs.jwks).append((Object)this.jwksUri, (Object)rhs.jwksUri).append((Object)this.tokenEndpointAuthenticationMethod, (Object)rhs.tokenEndpointAuthenticationMethod).append((Object)this.logoutUri, (Object)rhs.logoutUri).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.clientId).append((Object)this.clientSecret).append((Object)this.idTokenIssuer).append(this.signIdToken).append((Object)this.idTokenSigningAlg).append(this.encryptIdToken).append((Object)this.idTokenEncryptionAlg).append((Object)this.idTokenEncryptionEncoding).append((Object)this.userInfoSigningAlg).append((Object)this.userInfoEncryptedResponseAlg).append((Object)this.userInfoEncryptedResponseEncoding).append(this.jwtAccessToken).append(this.bypassApprovalPrompt).append(this.generateRefreshToken).append((Object)this.subjectType).append((Object)this.applicationType).append(this.redirectUris).append(this.supportedGrantTypes).append(this.supportedResponseTypes).append(this.scopes).append((Object)this.jwks).append((Object)this.jwksUri).append((Object)this.tokenEndpointAuthenticationMethod).append((Object)this.logoutUri).toHashCode();
    }
}

