/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.settings;

import de.agilecoders.wicket.webjars.collectors.AssetPathCollector;
import de.agilecoders.wicket.webjars.collectors.ClasspathAssetPathCollector;
import de.agilecoders.wicket.webjars.collectors.FileAssetPathCollector;
import de.agilecoders.wicket.webjars.collectors.VfsAssetPathCollector;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.settings.ResourceStreamProvider;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import java.time.Duration;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.wicket.util.lang.Args;

public class WebjarsSettings
implements IWebjarsSettings {
    private static final String DEFAULT_WEBJAR_CDN = "//cdn.jsdelivr.net:80/webjars/org.webjars";
    private Duration readFromCacheTimeout;
    private ResourceStreamProvider resourceStreamProvider = ResourceStreamProvider.bestFitting();
    private String recentVersionPlaceHolder = "current";
    private AssetPathCollector[] assetPathCollectors;
    private String webjarsPackage = "META-INF.resources.webjars";
    private String webjarsPath = this.webjarsPackage.replace('.', '/');
    private Pattern resourcePattern = Pattern.compile("META-INF/resources/webjars/.*");
    private Pattern webjarsPathPattern = Pattern.compile("/webjars/([^\\/]*)\\/([^\\/]*)\\/(.*)");
    private boolean useCdnResources = false;
    private String cdnUrl = "//cdn.jsdelivr.net:80/webjars/org.webjars";

    public WebjarsSettings() {
        this.readFromCacheTimeout = Duration.ofSeconds(3L);
        this.assetPathCollectors = new AssetPathCollector[]{new ClasspathAssetPathCollector(), new VfsAssetPathCollector(), new FileAssetPathCollector(this.webjarsPath)};
    }

    @Override
    public ResourceStreamProvider resourceStreamProvider() {
        return this.resourceStreamProvider;
    }

    @Override
    public AssetPathCollector[] assetPathCollectors() {
        return this.assetPathCollectors;
    }

    @Override
    public String webjarsPackage() {
        return this.webjarsPackage;
    }

    @Override
    public String webjarsPath() {
        return this.webjarsPath;
    }

    @Override
    public ClassLoader[] classLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), WebJarAssetLocator.class.getClassLoader(), this.getClass().getClassLoader()};
    }

    @Override
    public Pattern resourcePattern() {
        return this.resourcePattern;
    }

    @Override
    public Pattern webjarsPathPattern() {
        return this.webjarsPathPattern;
    }

    @Override
    public String recentVersionPlaceHolder() {
        return this.recentVersionPlaceHolder;
    }

    @Override
    public Duration readFromCacheTimeout() {
        return this.readFromCacheTimeout;
    }

    @Override
    public boolean useCdnResources() {
        return this.useCdnResources;
    }

    @Override
    public String cdnUrl() {
        return this.cdnUrl;
    }

    public WebjarsSettings readFromCacheTimeout(Duration readFromCacheTimeout) {
        this.readFromCacheTimeout = readFromCacheTimeout;
        return this;
    }

    public WebjarsSettings recentVersionPlaceHolder(String recentVersionPlaceHolder) {
        this.recentVersionPlaceHolder = recentVersionPlaceHolder;
        return this;
    }

    public WebjarsSettings resourcePattern(Pattern resourcePattern) {
        this.resourcePattern = resourcePattern;
        return this;
    }

    public WebjarsSettings webjarsPath(String webjarsPath) {
        this.webjarsPath = (String)Args.notEmpty((CharSequence)webjarsPath, (String)"webjarsPath");
        return this;
    }

    public WebjarsSettings webjarsPackage(String webjarsPackage) {
        this.webjarsPackage = (String)Args.notEmpty((CharSequence)webjarsPackage, (String)"webjarsPackage");
        return this;
    }

    public WebjarsSettings resourceStreamProvider(ResourceStreamProvider resourceStreamProvider) {
        this.resourceStreamProvider = (ResourceStreamProvider)Args.notNull((Object)resourceStreamProvider, (String)"resourceStreamProvider");
        return this;
    }

    public WebjarsSettings assetPathCollectors(AssetPathCollector ... assetPathCollectors) {
        this.assetPathCollectors = (AssetPathCollector[])Args.notNull((Object)assetPathCollectors, (String)"assetPathCollectors");
        return this;
    }

    public WebjarsSettings useCdnResources(boolean useCdnResources) {
        this.useCdnResources = useCdnResources;
        return this;
    }

    public WebjarsSettings cdnUrl(String cdnUrl) {
        this.cdnUrl = cdnUrl;
        return this;
    }

    public String toString() {
        return "WebjarsSettings{readFromCacheTimeout=" + this.readFromCacheTimeout + ", resourceStreamProvider=" + this.resourceStreamProvider + ", recentVersionPlaceHolder='" + this.recentVersionPlaceHolder + "', assetPathCollectors=" + Arrays.toString(this.assetPathCollectors) + ", webjarsPackage='" + this.webjarsPackage + "', webjarsPath='" + this.webjarsPath + "', resourcePattern=" + this.resourcePattern + ", webjarsPathPattern=" + this.webjarsPathPattern + ", useCdnResources=" + this.useCdnResources + ", cdnUrl='" + this.cdnUrl + "'}";
    }
}

